% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_opal.R
\name{get_resources}
\alias{get_resources}
\title{Get records of all current user's resources on LMS OPAL}
\usage{
get_resources(api_user = NULL, api_password = NULL, endpoint = NULL)
}
\arguments{
\item{api_user}{A character value of the username in the OPAL.}

\item{api_password}{A character value of the password in the OPAL.}

\item{endpoint}{A string of endpoint of LMS Opal; by default it is got from
environment variable \code{QTI_API_ENDPOINT}. To set a global environment
variable, you need to call \code{Sys.setenv(QTI_API_ENDPOINT='xxxxxxxxxxxxxxx')}
or you can put these command into .Renviron.}
}
\value{
A dataframe with attributes of user's resources.
}
\description{
Get records of all current user's resources on LMS OPAL
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
df <- get_resources()
\dontshow{\}) # examplesIf}
}
