% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_cols}
\alias{normalize_cols}
\title{Build an optree pipeline that normalizes a set of columns so each column sums to one in each partition.}
\usage{
normalize_cols(source, columns, ..., partitionby = NULL,
  env = parent.frame())
}
\arguments{
\item{source}{relop tree or data.frame source.}

\item{columns}{character, columns to normalize.}

\item{...}{force later arguments to bind by name.}

\item{partitionby}{partitioning (window function) column names to define partitions.}

\item{env}{environment to look for values in.}
}
\description{
This is an example of building up a desired pre-prepared pipeline fragment from relop nodes.
}
\examples{

# by hand logistic regression example
scale <- 0.237
d <- mk_td("survey_table",
                  c("subjectID", "surveyCategory", "assessmentTotal"))
optree <- d \%.>\%
  extend_nse(.,
             probability \%:=\%
               exp(assessmentTotal * scale))  \%.>\%
  normalize_cols(.,
                 "probability",
                 partitionby = 'subjectID') \%.>\%
  pick_top_k(.,
             partitionby = 'subjectID',
             orderby = c('probability', 'surveyCategory'),
             reverse = c('probability')) \%.>\%
  rename_columns(., 'diagnosis' \%:=\% 'surveyCategory') \%.>\%
  select_columns(., c('subjectID',
                      'diagnosis',
                      'probability')) \%.>\%
  orderby(., 'subjectID')
cat(format(optree))

}
