% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regerr.R
\name{regerr}
\alias{regerr}
\title{Plot for variability}
\usage{
regerr(data, x, y, ll, ul, title, ylab, comp, col1, col2, ascending = TRUE,
  flip = TRUE, ...)
}
\arguments{
\item{data}{Data set}

\item{x}{x-axis}

\item{y}{y-axis}

\item{ll}{Lower limit}

\item{ul}{Upper limit}

\item{title}{Title for the plot}

\item{ylab}{Label for y-axis}

\item{comp}{Compare a specific bar from the rest for a vivid comparison
eg. National compared to the different districts}

\item{col1}{Color for bars}

\item{col2}{Color for the 'diff' bar}

\item{ascending}{Sort data ascending order}

\item{flip}{Flip plot horizontally}

\item{...}{Additional arguments}
}
\description{
Create a plot to show uncertainty either by showing the Standard Error of the
Mean (SEM) or Confidence Interval (CI). Lower and upper limit should be
specified. Figure should also be commented if the variability is a SEM or CI.
}
\examples{
# basic usage
regerr(hfdata, inst, case2, ll, ul)
regerr(hfdata, inst, case2, ll, ul, comp="Sabah")

}
