% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iri.R
\name{CalculateIRIContinuously}
\alias{CalculateIRIContinuously}
\title{Computes the IRI for a continuously increasing segment given a road profile}
\usage{
CalculateIRIContinuously(profile, iri_coef)
}
\arguments{
\item{profile}{Road profile (as numeric vector in mm) whose IRIs are to be
calculated.}

\item{iri_coef}{Set of coefficients for specific sample size (e. g.
IRI_COEF_250).}
}
\value{
Calculated IRIs (m/km) for increasing segments (as numeric vector) of
  the given profile.
}
\description{
Depending on the sample size a certain buffer has to be attached to the
profile for calculation the slope at the end.
}
\examples{
generate_test_profile <- function (x) {
if (x < 1) return(0)
if (x >= 1 && x < 3) return(x - 1)
if (x >= 3 && x < 5) return(5 - x)
if (x >= 5) return(0)
}
x <- seq(.25, 30, by = .25)
test_profile <- data.frame(x = x, profile=sapply(x, generate_test_profile))
test_profile$iri <- CalculateIRIContinuously(
                      test_profile$profile, IRI_COEF_250)
plot(x = test_profile$x, y = test_profile$profile, ylim = c(0, 8),
     xlim = c(0,25), type = "l")
lines(x = test_profile$x, y = test_profile$iri*10)
}
