% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsat_list_data.R
\name{rsat_list_data}
\alias{rsat_list_data}
\alias{rsat_list_data,rtoi-method}
\alias{rsat_list_data,rtoi}
\title{List the information available for an \code{rtoi}}
\usage{
rsat_list_data(x, ...)

\S4method{rsat_list_data}{rtoi}(x, ...)
}
\arguments{
\item{x}{an \code{rtoi} object.}

\item{...}{additional arguments.}
}
\value{
a \code{data.frame} of the available information.
}
\description{
Displays the existing products, bands,
and processing levels for a given \code{rtoi}
}
\examples{
navarre <- read_rtoi(system.file("ex/Navarre",package="rsat"))

print(navarre)

# print empty rtoi
rsat_list_data(navarre)

pamplona <- read_rtoi(system.file("ex/Pamplona",package="rsat"))
print(pamplona)

rtoi.data <- rsat_list_data(pamplona)
# print mosaicked bands
print(rtoi.data)

# print mosaicked bands + derived NDVI
pamplona.derived <- read_rtoi(system.file("ex/PamplonaDerived",package="rsat"))
rsat_list_data(pamplona.derived)
}
