% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{sc_zip}
\alias{sc_zip}
\title{Subset results to those within specified area around zip code.}
\usage{
sc_zip(sccall, zip, distance = 25, km = FALSE)
}
\arguments{
\item{sccall}{Current list of parameters carried forward from prior
functions in the chain (ignore)}

\item{zip}{A 5-digit zipcode}

\item{distance}{An integer distance in miles or kilometers}

\item{km}{A boolean value set to \code{TRUE} if distance should be
in kilometers (default is \code{FALSE} for miles)}
}
\description{
Subset results to those within specified area around zip code.
}
\section{Note}{
 Zip codes with leading zeros (Northeast) can be
    called either using a string (\code{'02111'}) or as a numeric
    (\code{02111}). R will drop the leading zero from the second
    version, but \code{sc_zip()} will add it back before the
    call. The shortened version without the leading zero may also
    be used (2111 and '2111' both become '02111'), but is not
    recommended for clarity.
}

\examples{
\dontrun{
sc_zip(37203)
sc_zip(37203, 50)
sc_zip(37203, 50, km = TRUE)
sc_zip('02111')              # 1. Using string
sc_zip(02111)                # 2. Dropped leading zero will be added
sc_zip(2111)                 # 3. Will become '02111' (not recommended)
}
}
