% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-SDMXREST20RequestBuilder.R, R/SDMXREST20RequestBuilder-methods.R
\docType{class}
\name{SDMXREST20RequestBuilder}
\alias{SDMXREST20RequestBuilder}
\alias{SDMXREST20RequestBuilder,SDMXREST20RequestBuilder-method}
\alias{SDMXREST20RequestBuilder-class}
\title{Class "SDMXREST20RequestBuilder"}
\usage{
SDMXREST20RequestBuilder(regUrl, repoUrl, compliant, unsupportedResources,
                        skipProviderId, forceProviderId)
}
\arguments{
\item{regUrl}{an object of class "character" giving the base Url of the SDMX
service registry}

\item{repoUrl}{an object of class "character" giving the base Url of the SDMX
service repository}

\item{compliant}{an object of class "logical" indicating if the web-service
is compliant with the SDMX REST web-service specifications}

\item{unsupportedResources}{an object of class "list" giving eventual unsupported
REST resources. Default is an empty list object}

\item{skipProviderId}{an object of class "logical" indicating that the provider
agencyIdshould be skipped. Used to control lack of strong SDMX REST compliance
from data providers. For now, it applies only for the "data" resource.}

\item{forceProviderId}{an object of class "logical" indicating if the provider
       agencyId has to be added at the end of the request. Default value is
       \code{FALSE}. For some providers, the \code{all} value for the provider
       agency id is not allowed, in this case, the \code{agencyId} of the data
       provider has to be forced in the web-request}
}
\description{
A experimental class to handle a SDMX 2.0 service request builder
}
\section{Slots}{

\describe{
\item{\code{regUrl}}{an object of class "character" giving the base Url of the SDMX service registry}

\item{\code{repoUrl}}{an object of class "character" giving the base Url of the SDMX service repository}

\item{\code{compliant}}{an object of class "logical" indicating if the web-service is compliant with the SDMX REST web-service specifications}
}}
\section{Warning}{

This class is not useful in itself, but all SDMX non-abstract classes will
encapsulate it as slot, when parsing an SDMX-ML document.
}
\examples{
#how to create a SDMXREST20RequestBuilder
  requestBuilder <- SDMXREST20RequestBuilder(
    regUrl = "http://www.myorg/registry",
    repoUrl = "http://www.myorg/repository", compliant = FALSE)
}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}

