% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{length_euclidean}
\alias{length_euclidean}
\alias{length_geodesic}
\alias{length_vincenty}
\alias{length_haversine}
\title{Calculate LineString Length}
\usage{
length_euclidean(x)

length_geodesic(x)

length_vincenty(x)

length_haversine(x)
}
\arguments{
\item{x}{an object of class \code{rsgeo}}
}
\value{
A numeric vector
}
\description{
For a given LineString or MultiLineString geometry, calculate its length.
Other geometries will return a value of \code{NA}.
}
\details{
\subsection{Notes}{
\itemize{
\item Vicenty, Geodesic, and Haversine methods will return in units of meters.
\item Geodesic length will always converge and is more accurate than the Vicenty methods.
\item Haversine uses a mean earth radius of 6371.088 km.
}

See \href{https://docs.rs/geo/latest/geo/index.html#length}{\code{geo}} docs for more details.
}
}
\examples{
set.seed(0)
y <- runif(25, -5, 5)
x <- 1:25

ln <- geom_linestring(x, y)

length_euclidean(ln)
length_geodesic(ln)
length_vincenty(ln)
length_haversine(ln)
}
