% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCBI_snp_query.R
\name{ncbi_snp_query}
\alias{ncbi_snp_query}
\title{Query NCBI's dbSNP for information on a set of SNPs}
\usage{
ncbi_snp_query(SNPs, key = NULL, ...)
}
\arguments{
\item{SNPs}{(character) A vector of SNPs (rs numbers).}

\item{key}{(character) NCBI Entrez API key. optional.
See "NCBI Authenication" in \link{rsnps-package}}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
A dataframe with columns:
\itemize{
\item Query: The rs ID that was queried.
\item Chromosome: The chromosome that the marker lies on.
\item Marker: The name of the marker. If the rs ID queried
has been merged, the up-to-date name of the marker is returned here, and
a warning is issued.
\item Class: The marker's 'class'. See
\url{http://www.ncbi.nlm.nih.gov/projects/SNP/snp_legend.cgi?legend=snpClass}
for more details.
\item Gene: If the marker lies within a gene (either within the exon
or introns of a gene), the name of that gene is returned here; otherwise,
\code{NA}. Note that
the gene may not be returned if the marker lies too far upstream or downstream
of the particular gene of interest.
\item Alleles: The alleles associated with the SNP if it is a
SNV; otherwise, if it is an INDEL, microsatellite, or other kind of
polymorphism the relevant information will be available here.
\item Major: The major allele of the SNP, on the forward strand,
given it is an SNV; otherwise, \code{NA}.
\item Minor: The minor allele of the SNP, on the forward strand,
given it is an SNV; otherwise, \code{NA}.
\item MAF: The minor allele frequency of the SNP, given it is an SNV.
This is drawn from the current global reference population used by NCBI.
\item BP: The chromosomal position, in base pairs, of the marker,
as aligned with the current genome used by dbSNP. we add 1 to the base
pair position in the BP column in the output data.frame to agree with
what the dbSNP website has.
}
}
\description{
This function queries NCBI's dbSNP for information related to the latest
dbSNP build and latest reference genome for information on the vector
of SNPs submitted.
}
\details{
This function currently pulling data for Assembly 38 - in particular
note that if you think the BP position is wrong, that you may be
hoping for the BP position for a different Assembly. With ENTREZ
we cannot specify which assembly to pull data from, so it's stuck
with 38.

Note that you are limited in the number of SNPs you pass in to one
request because URLs can only be so long. Around 600 is likely the max you
can pass in, though may be somewhat more. Break up your vector of SNP
codes into pieces of 600 or less and do repeated requests to get all data.
}
\examples{
\dontrun{
## an example with both merged SNPs, non-SNV SNPs, regular SNPs,
## SNPs not found, microsatellite
SNPs <- c("rs332", "rs420358", "rs1837253", "rs1209415715", "rs111068718")
ncbi_snp_query(SNPs)
# ncbi_snp_query("123456") ##invalid: must prefix with 'rs'
ncbi_snp_query("rs420358")
ncbi_snp_query("rs332") # warning that its merged into another, try that
ncbi_snp_query("rs121909001")
ncbi_snp_query("rs1837253")
ncbi_snp_query("rs1209415715")
ncbi_snp_query("rs111068718") 
ncbi_snp_query(SNPs='rs9970807')

# Curl debugging
ncbi_snp_query("rs121909001")
ncbi_snp_query("rs121909001", verbose = TRUE)
}
}
\references{
\url{https://www.ncbi.nlm.nih.gov/projects/SNP/}
}
\seealso{
\code{\link[=ncbi_snp_query2]{ncbi_snp_query2()}}
}
