% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\name{delete}
\alias{delete}
\alias{delete,character-method}
\alias{delete,SsimObject-method}
\title{Delete SsimLibrary, Project, Scenario, Folder, Chart or Datasheet}
\usage{
delete(
  ssimObject,
  project = NULL,
  scenario = NULL,
  folder = NULL,
  chart = NULL,
  datasheet = NULL,
  force = FALSE,
  removeBackup = FALSE,
  removePublish = FALSE,
  removeCustom = FALSE,
  session = NULL
)

\S4method{delete}{character}(
  ssimObject,
  project = NULL,
  scenario = NULL,
  folder = NULL,
  chart = NULL,
  datasheet = NULL,
  force = FALSE,
  removeBackup = FALSE,
  removePublish = FALSE,
  removeCustom = FALSE,
  session = NULL
)

\S4method{delete}{SsimObject}(ssimObject, project, scenario, folder, chart, datasheet, force, session)
}
\arguments{
\item{ssimObject}{\code{\link{SsimLibrary}}, \code{\link{Project}},
\code{\link{Scenario}}, \code{\link{Folder}}, or \code{\link{Chart}}
object, or character (i.e. path to a SsimLibrary)}

\item{project}{character string, numeric, or vector of these. One or more
\code{\link{Project}} names or ids. Note that project argument is ignored
if ssimObject is a list. Note that integer ids are slightly faster (optional)}

\item{scenario}{character string, numeric, or vector of these. One or more
\code{\link{Scenario}} names or ids. Note that scenario argument is
ignored if ssimObject is a list. Note that integer ids are slightly faster
(optional)}

\item{folder}{character string, numeric, or vector of these. One or more
\code{\link{Folder}} names or ids. Note that folder argument is
ignored if ssimObject is a list. Note that integer ids are slightly faster
(optional)}

\item{chart}{character string, numeric, or vector of these. One or more
\code{\link{Chart}} names or ids. Note that chart argument is
ignored if SsimObject is a list. Note that integer ids are slightly faster
(optional)}

\item{datasheet}{character string or vector of these. One or more datasheet
names (optional)}

\item{force}{logical. If \code{FALSE} (default), user will be prompted to approve
removal of each item}

\item{removeBackup}{logical. If \code{TRUE}, will remove the backup folder when
deleting a library. Default is \code{FALSE}}

\item{removePublish}{logical. If \code{TRUE}, will remove the publish folder when
deleting a library. Default is \code{FALSE}}

\item{removeCustom}{logical. If \code{TRUE} and custom folders have been configured
for a library, then will remove the custom publish and/or backup folders when
deleting a library. Note that the \code{removePublish} and \code{removeBackup} arguments
must also be set to \code{TRUE} to remove the respective custom folders. Default
is \code{FALSE}}

\item{session}{\code{\link{Session}} object. If \code{NULL} (default), session()
will be used. Only applicable when \code{ssimObject} argument is a character}
}
\value{
Invisibly returns a list of boolean values corresponding to each
input: \code{TRUE} upon success (i.e.successful deletion) and \code{FALSE} upon failure.
}
\description{
Deletes one or more items. Note that this is irreversible.
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session, SsimLibrary, and Project
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)
myProject <- project(myLibrary, project = "a project")

# Check the Projects associated with this SsimLibrary
project(myLibrary)

# Delete Project
delete(myLibrary, project = "a project", force = TRUE)

# Check that Project was successfully deleted from SsimLibrary
project(myLibrary)
}

}
