% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_rtables.R
\name{compare_rtables}
\alias{compare_rtables}
\title{Compare two rtables}
\usage{
compare_rtables(object, expected, tol = 0.1, comp.attr = TRUE)
}
\arguments{
\item{object}{rtable to test}

\item{expected}{rtable expected}

\item{tol}{numerical tolorance}

\item{comp.attr}{boolean compare attributes}
}
\value{
a matrix of class \code{"rtables_diff"} representing the differences
between \code{object} and \code{expected} as described above.
}
\description{
Prints a matrix where \code{.} means cell matches, \code{X} means cell does
cells do not match, \code{+} cell (row) is missing, and \code{-} cell (row)
should not be there.
}
\note{
In its current form \code{compare_rtables} does not take structure into account,
only row and cell position.
}
\examples{

t1 <- rtable(header = c("A", "B"), format = "xx", rrow("row 1", 1, 2))
t2 <- rtable(header = c("A", "B", "C"), format = "xx", rrow("row 1", 1, 2, 3))

compare_rtables(object = t1, expected = t2)

if(interactive()){
Viewer(t1, t2)
}

 expected <- rtable(
    header = c("ARM A\nN=100", "ARM B\nN=200"),
    format = "xx",
    rrow("row 1", 10, 15),
    rrow(),
    rrow("section title"),
    rrow("row colspan", rcell(c(.345543, .4432423), colspan = 2, format = "(xx.xx, xx.xx)"))
 )

expected

 object <- rtable(
    header = c("ARM A\nN=100", "ARM B\nN=200"),
    format = "xx",
    rrow("row 1", 10, 15),
    rrow("section title"),
    rrow("row colspan", rcell(c(.345543, .4432423), colspan = 2, format = "(xx.xx, xx.xx)"))
 )

 compare_rtables(object, expected)

 compare_rtables(object, expected, comp.attr = FALSE)

 object <- rtable(
    header = c("ARM A\nN=100", "ARM B\nN=200"),
    format = "xx",
    rrow("row 1", 10, 15),
    rrow(),
    rrow("section title")
 )

 compare_rtables(object, expected)

 object <- rtable(
    header = c("ARM A\nN=100", "ARM B\nN=200"),
    format = "xx",
    rrow("row 1", 14, 15.03),
    rrow(),
    rrow("section title"),
    rrow("row colspan", rcell(c(.345543, .4432423), colspan = 2, format = "(xx.xx, xx.xx)"))
 )

 compare_rtables(object, expected)

 object <- rtable(
    header = c("ARM A\nN=100", "ARM B\nN=200"),
    format = "xx",
    rrow("row 1", 10, 15),
    rrow(),
    rrow("section title"),
    rrow("row colspan", rcell(c(.345543, .4432423), colspan = 2, format = "(xx.x, xx.x)"))
 )

 compare_rtables(object, expected)

}
