% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{add_existing_table}
\alias{add_existing_table}
\title{Add an already calculated table to the layout}
\usage{
add_existing_table(lyt, tt, indent_mod = 0)
}
\arguments{
\item{lyt}{layout object pre-data used for tabulation}

\item{tt}{TableTree (or related class). A TableTree object representing a populated table.}

\item{indent_mod}{numeric. Modifier for the default indent position for the structure created by this function(subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which corresponds to the unmodified default behavior.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{build_table}.
}
\description{
Add an already calculated table to the layout
}
\examples{
tbl1 <- basic_table() \%>\%
   split_cols_by("ARM") \%>\%
   analyze("AGE", afun = mean, format = "xx.xx") \%>\%
   build_table(DM)

tbl1

tbl2 <- basic_table() \%>\% split_cols_by("ARM") \%>\%
   analyze("AGE", afun = sd, format = "xx.xx") \%>\%
   add_existing_table(tbl1) \%>\%
   build_table(DM)

tbl2

table_structure(tbl2)

row_paths_summary(tbl2)
}
\author{
Gabriel Becker
}
