% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00tabletrees.R
\docType{class}
\name{VarLevelSplit-class}
\alias{VarLevelSplit-class}
\alias{VarLevelSplit}
\alias{VarLevWBaselineSplit}
\title{Split on levels within a variable}
\usage{
VarLevelSplit(
  var,
  split_label,
  labels_var = NULL,
  cfun = NULL,
  cformat = NULL,
  split_fun = NULL,
  split_format = NULL,
  valorder = NULL,
  split_name = var,
  child_labels = c("default", "visible", "hidden"),
  extra_args = list(),
  indent_mod = 0L,
  label_pos = c("topleft", "hidden", "visible"),
  cindent_mod = 0L,
  cvar = "",
  cextra_args = list(),
  page_prefix = NA_character_
)

VarLevWBaselineSplit(
  var,
  ref_group,
  labels_var = var,
  split_label,
  split_fun = NULL,
  label_fstr = "\%s - \%s",
  cfun = NULL,
  cformat = NULL,
  cvar = "",
  split_format = NULL,
  valorder = NULL,
  split_name = var,
  extra_args = list()
)
}
\arguments{
\item{var}{string, variable name}

\item{split_label}{string. Label string to be associated with the table generated by the split. Not to be confused with labels assigned to each child (which are based on the data and type of split during tabulation).}

\item{labels_var}{string, name of variable containing labels to be displayed for the values of \code{var}}

\item{cfun}{list/function/NULL. tabulation function(s) for creating content rows. Must accept \code{x} or \code{df} as first parameter. Must accept \code{labelstr} as the second argument. Can optionally accept all optional arguments accepted by analysis functions. See \code{\link{analyze}}.}

\item{cformat}{format spec. Format for content rows}

\item{split_fun}{function/NULL. custom splitting function See \code{\link{custom_split_funs}}}

\item{split_format}{FormatSpec. Default format associated with the split being created.}

\item{valorder}{character vector. Order that the split children should appear in resulting table.}

\item{split_name}{string. Name associiated with this split (for pathing, etc)}

\item{child_labels}{string. One of \code{"default"}, \code{"visible"}, \code{"hidden"}. What should the display behavior be for the  labels (ie label rows) of the children of this split. Defaults to \code{"default"} which flags the label row as visible only if the child has 0 content rows.}

\item{extra_args}{list. Extra arguments to be passed to the tabulation function. Element position in thte list corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do not match a formal argument of the ttabulation function.}

\item{indent_mod}{numeric. Modifier for the default indent position for the structure created by this function(subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which corresponds to the unmodified default behavior.}

\item{label_pos}{character(1). Location the variable label should be displayed, Accepts  hidden (default for non-analyze row splits), visible, topleft, and - for analyze splits only - default.  For analyze calls, \code{default} indicates that the variable
should be visible if and only if multiple variables are analyzed at the same level of nesting.}

\item{cindent_mod}{numeric(1). The indent modifier for the content tables generated by this split.}

\item{cvar}{character(1). The variable, if any, which the content function should accept. Defaults to NA.}

\item{cextra_args}{list. Extra arguments to be passed to the content function when tabulating row group summaries.}

\item{page_prefix}{character(1). Prefix, to be appended with the split value, when forcing pagination between the children of this split/table}

\item{ref_group}{character. Value of \code{var} to be taken as the ref_group/control to be compared against.}

\item{label_fstr}{string. An sprintf style format string containing. For non-comparison splits, it can contain  up to one \code{"\%s"} which takes the current split value and generates the row/column label. Comparison-based splits it can contain up to two \code{"\%s"}.}
}
\value{
a \code{VarLevelSplit} object.
}
\description{
Split on levels within a variable
}
\author{
Gabriel Becker
}
