% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_afun_utils.R
\name{in_rows}
\alias{in_rows}
\title{Create multiple rows in analysis or summary functions}
\usage{
in_rows(
  ...,
  .list = NULL,
  .names = NULL,
  .labels = NULL,
  .formats = NULL,
  .indent_mods = NULL,
  .cell_footnotes = list(NULL),
  .row_footnotes = list(NULL),
  .aligns = NULL,
  .format_na_strs = NULL
)
}
\arguments{
\item{...}{single row defining expressions}

\item{.list}{list. list cell content, usually \code{rcells}, the \code{.list} is concatenated to \code{...}}

\item{.names}{character or NULL. Names of the returned list/structure.}

\item{.labels}{character or NULL. labels for the defined rows}

\item{.formats}{character or NULL. Formats for the values}

\item{.indent_mods}{integer or NULL. Indent modificatons for the defined rows.}

\item{.cell_footnotes}{list. Referential footnote messages to be associated by name with \emph{cells}}

\item{.row_footnotes}{list. Referential footnotes messages to be associated by name with \emph{rows}}

\item{.aligns}{character or NULL. Alignments for the cells}

\item{.format_na_strs}{character or NULL. NA strings for the cells}
}
\value{
an \code{RowsVerticalSection} object (or \code{NULL}). The details of this object should be considered an internal implementation detail.
}
\description{
define the cells that get placed into multiple rows in \code{afun}
}
\examples{
in_rows(1, 2, 3, .names = c("a", "b", "c"))
in_rows(1, 2, 3, .labels = c("a", "b", "c"))
in_rows(1, 2, 3, .names = c("a", "b", "c"), .labels = c("AAA", "BBB", "CCC"))

in_rows(.list = list(a = 1, b = 2, c = 3))
in_rows(1, 2, .list = list(3), .names = c("a", "b", "c"))

basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  analyze("AGE", afun = function(x) {
    in_rows(
       "Mean (sd)" = rcell(c(mean(x), sd(x)), format = "xx.xx (xx.xx)"),
       "Range" = rcell(range(x), format = "xx.xx - xx.xx")
    )
  }) \%>\%
  build_table(ex_adsl)

}
\seealso{
\code{analyze}
}
