% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_toString.R
\name{tostring}
\alias{tostring}
\alias{toString,VTableTree-method}
\title{Convert an \code{rtable} object to a string}
\usage{
\S4method{toString}{VTableTree}(
  x,
  widths = NULL,
  col_gap = 3,
  hsep = horizontal_sep(x),
  indent_size = 2,
  tf_wrap = FALSE,
  max_width = NULL
)
}
\arguments{
\item{x}{table object}

\item{widths}{widths of row.name and columns}

\item{col_gap}{gap between columns}

\item{hsep}{character to create line separator}

\item{indent_size}{numeric(1). Number of spaces to use per indent level.
Defaults to 2}

\item{tf_wrap}{logical(1). Should  the texts for  title, subtitle,
and footnotes be wrapped?}

\item{max_width}{integer(1), character(1) or NULL. Width that title
and   footer   (including   footnotes)  materials   should   be
word-wrapped to. If NULL, it is  set to the current print width
of the  session (\code{getOption("width")}). If set to \code{"auto"},
the width of the table (plus any table inset) is used. Ignored
completely if \code{tf_wrap} is \code{FALSE}.}
}
\value{
a string representation of \code{x} as it appears when printed.
}
\description{
Transform a complex object into a string representation ready
to be printed or written to a plain-text file
}
\details{
Manual insertion of newlines is not supported when \code{tf_wrap} is on
and will result in a warning and undefined wrapping behavior. Passing
vectors of already split strings remains supported, however in this
case each string is word-wrapped separately with the behavior
described above.
}
\examples{
library(dplyr)

iris2 <- iris \%>\%
  group_by(Species) \%>\%
  mutate(group = as.factor(rep_len(c("a", "b"), length.out = n()))) \%>\%
  ungroup()

lyt <- basic_table() \%>\%
  split_cols_by("Species") \%>\%
  split_cols_by("group") \%>\%
  analyze(c("Sepal.Length", "Petal.Width"), afun = list_wrap_x(summary) , format = "xx.xx")

tbl <- build_table(lyt, iris2)

cat(toString(tbl, col_gap = 3))
}
