% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_paginate.R
\name{pag_tt_indices}
\alias{pag_tt_indices}
\alias{paginate_table}
\title{Pagination of a \code{TableTree}}
\usage{
pag_tt_indices(
  tt,
  lpp = 15,
  min_siblings = 2,
  nosplitin = character(),
  colwidths = NULL,
  max_width = NULL,
  verbose = FALSE
)

paginate_table(
  tt,
  page_type = "letter",
  font_family = "Courier",
  font_size = 8,
  lineheight = 1,
  landscape = FALSE,
  pg_width = NULL,
  pg_height = NULL,
  margins = c(top = 0.5, bottom = 0.5, left = 0.75, right = 0.75),
  lpp = NA_integer_,
  cpp = NA_integer_,
  min_siblings = 2,
  nosplitin = character(),
  colwidths = NULL,
  tf_wrap = FALSE,
  max_width = NULL,
  verbose = FALSE
)
}
\arguments{
\item{tt}{(\code{TableTree} or related class)\cr a \code{TableTree} object representing a populated table.}

\item{lpp}{(\code{numeric(1)})\cr maximum lines per page including (re)printed header and context rows.}

\item{min_siblings}{(\code{numeric(1)})\cr minimum sibling rows which must appear on either side of pagination row for a
mid-subtable split to be valid. Defaults to 2.}

\item{nosplitin}{(\code{character})\cr names of sub-tables where page-breaks are not allowed, regardless of other
considerations. Defaults to none.}

\item{colwidths}{(\code{numeric})\cr a vector of column widths for use in vertical pagination.}

\item{max_width}{(\code{integer(1)}, \code{string} or \code{NULL})\cr width that title and footer (including
footnotes) materials should be word-wrapped to. If \code{NULL}, it is set to the current print width of the
session (\code{getOption("width")}). If set to \code{"auto"}, the width of the table (plus any table inset) is
used. Parameter is ignored if \code{tf_wrap = FALSE}.}

\item{verbose}{(\code{flag})\cr whether additional information should be displayed to the user. Defaults to \code{FALSE}.}

\item{page_type}{(\code{string})\cr name of a page type. See \code{\link[formatters]{page_types}}. Ignored
when \code{pg_width} and \code{pg_height} are set directly.}

\item{font_family}{(\code{string})\cr name of a font family. An error will be thrown
if the family named is not monospaced. Defaults to \code{"Courier"}.}

\item{font_size}{(\code{numeric(1)})\cr font size. Defaults to \code{12}.}

\item{lineheight}{(\code{numeric(1)})\cr line height. Defaults to \code{1}.}

\item{landscape}{(\code{flag})\cr whether the dimensions of \code{page_type} should be
inverted for landscape orientation. Defaults to \code{FALSE}, ignored when \code{pg_width} and
\code{pg_height} are set directly.}

\item{pg_width}{(\code{numeric(1)})\cr page width in inches.}

\item{pg_height}{(\code{numeric(1)})\cr page height in inches.}

\item{margins}{(\code{numeric(4)})\cr named numeric vector containing \code{"bottom"}, \code{"left"},
\code{"top"}, and \code{"right"} margins in inches. Defaults to \code{.5} inches for both vertical
margins and \code{.75} for both horizontal margins.}

\item{cpp}{(\code{numeric(1)} or \code{NULL})\cr width (in characters) of the pages for horizontal pagination.
\code{NA} (the default) indicates \code{cpp} should be inferred from the page size; \code{NULL} indicates no horizontal
pagination should be done regardless of page size.}

\item{tf_wrap}{(\code{flag})\cr whether the text for title, subtitles, and footnotes should be wrapped.}
}
\value{
\itemize{
\item \code{pag_tt_indices} returns a list of paginated-groups of row-indices of \code{tt}.
\item \code{paginate_table} returns the subtables defined by subsetting by the indices defined by \code{pag_tt_indices}.
}
}
\description{
Paginate an \code{rtables} table in the vertical and/or horizontal direction, as required for the specified page size.
}
\details{
\code{rtables} pagination is context aware, meaning that label rows and row-group summaries (content rows) are repeated
after (vertical) pagination, as appropriate. This allows the reader to immediately understand where they are in the
table after turning to a new page, but does also mean that a rendered, paginated table will take up more lines of
text than rendering the table without pagination would.

Pagination also takes into account word-wrapping of title, footer, column-label, and formatted cell value content.

Vertical pagination information (pagination \code{data.frame}) is created using (\code{make_row_df}).

Horizontal pagination is performed by creating a pagination data frame for the columns, and then applying the same
algorithm used for vertical pagination to it.

If physical page size and font information are specified, these are used to derive lines-per-page (\code{lpp}) and
characters-per-page (\code{cpp}) values.

The full multi-direction pagination algorithm then is as follows:
\enumerate{
\item Adjust \code{lpp} and \code{cpp} to account for rendered elements that are not rows (columns):
}
\itemize{
\item titles/footers/column labels, and horizontal dividers in the vertical pagination case
\item row-labels, table_inset, and top-left materials in the horizontal case
}
\enumerate{
\item Perform 'forced pagination' representing page-by row splits, generating 1 or more tables.
\item Perform vertical pagination separately on each table generated in (1).
\item Perform horizontal pagination \strong{on the entire table} and apply the results to each table
page generated in (1)-(2).
\item Return a list of subtables representing full bi-directional pagination.
}

Pagination in both directions is done using the \emph{Core Pagination Algorithm} implemented in the \code{formatters} package:
}
\section{Pagination Algorithm}{



Pagination is performed independently in the vertical and horizontal
directions based solely on a \emph{pagination data frame}, which includes the
following information for each row/column:
\itemize{
\item Number of lines/characters rendering the row will take \strong{after
word-wrapping} (\code{self_extent})
\item The indices (\code{reprint_inds}) and number of lines (\code{par_extent})
of the rows which act as \strong{context} for the row
\item The row's number of siblings and position within its siblings
}

Given \code{lpp} (\code{cpp}) is already adjusted for rendered elements which
are not rows/columns and a data frame of pagination information,
pagination is performed via the following algorithm with \code{start = 1}.

Core Pagination Algorithm:
\enumerate{
\item Initial guess for pagination position is \code{start + lpp} (\code{start + cpp})
\item While the guess is not a valid pagination position, and \code{guess > start},
decrement guess and repeat.
\itemize{
\item An error is thrown if all possible pagination positions between
\code{start} and \code{start + lpp} (\code{start + cpp}) would be \verb{< start}
after decrementing
}
\item Retain pagination index
\item If pagination point was less than \code{NROW(tt)} (\code{ncol(tt)}), set
\code{start} to \code{pos + 1}, and repeat steps (1) - (4).
}

Validating Pagination Position:

Given an (already adjusted) \code{lpp} or \code{cpp} value, a pagination is invalid if:
\itemize{
\item The rows/columns on the page would take more than (adjusted) \code{lpp} lines/\code{cpp}
characters to render \strong{including}:
\itemize{
\item word-wrapping
\item (vertical only) context repetition
}
\item (vertical only) footnote messages and/or section divider lines
take up too many lines after rendering rows
\item (vertical only) row is a label or content (row-group summary) row
\item (vertical only) row at the pagination point has siblings, and
it has less than \code{min_siblings} preceding or following siblings
\item pagination would occur within a sub-table listed in \code{nosplitin}
}

}

\examples{
s_summary <- function(x) {
  if (is.numeric(x)) {
    in_rows(
      "n" = rcell(sum(!is.na(x)), format = "xx"),
      "Mean (sd)" = rcell(c(mean(x, na.rm = TRUE), sd(x, na.rm = TRUE)),
        format = "xx.xx (xx.xx)"
      ),
      "IQR" = rcell(IQR(x, na.rm = TRUE), format = "xx.xx"),
      "min - max" = rcell(range(x, na.rm = TRUE), format = "xx.xx - xx.xx")
    )
  } else if (is.factor(x)) {
    vs <- as.list(table(x))
    do.call(in_rows, lapply(vs, rcell, format = "xx"))
  } else {
    (
      stop("type not supported")
    )
  }
}

lyt <- basic_table() \%>\%
  split_cols_by(var = "ARM") \%>\%
  analyze(c("AGE", "SEX", "BEP01FL", "BMRKR1", "BMRKR2", "COUNTRY"), afun = s_summary)

tbl <- build_table(lyt, ex_adsl)
tbl

nrow(tbl)

row_paths_summary(tbl)

tbls <- paginate_table(tbl, lpp = 15)
mf <- matrix_form(tbl, indent_rownames = TRUE)
w_tbls <- propose_column_widths(mf) # so that we have the same column widths


tmp <- lapply(tbls, function(tbli) {
  cat(toString(tbli, widths = w_tbls))
  cat("\n\n")
  cat("~~~~ PAGE BREAK ~~~~")
  cat("\n\n")
})

}
