% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf_candidate_search.R
\name{cf_candidate_search}
\alias{cf_candidate_search}
\title{Campaign finance - candidate search}
\usage{
cf_candidate_search(campaign_cycle = NULL, query = NULL, key = NULL, ...)
}
\arguments{
\item{campaign_cycle}{An even-numbdered year in YYYY format. Presidential data:
2008-present; Congressional data: 2000-present}

\item{query}{Last name of a candidate}

\item{key}{(character) your Propublica API key; pass in, or loads from .Renviron as 
\code{PROPUBLICA_API_KEY}. See \code{\link{rtimes-package}} for info on rate limits.}

\item{...}{Curl options (debugging tools mostly) passed to 
\code{\link[crul]{HttpClient}}}
}
\description{
Campaign finance - candidate search
}
\examples{
\dontrun{
cf_candidate_search(campaign_cycle = 2016, query='Wilson')
cf_candidate_search(campaign_cycle = 2008, query='obama')
}
}
\references{
\url{http://propublica.github.io/campaign-finance-api-docs}
}
\seealso{
Other campaign-finance: \code{\link{cf_candidate_details}},
  \code{\link{cf_candidate_leaders}},
  \code{\link{cf_candidate_new}},
  \code{\link{cf_candidate_state}}
}
\keyword{internal}
