% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_resps.R
\name{delta2delta}
\alias{delta2delta}
\alias{set_deltas_equal}
\title{Set mapping between response categories and encoding plus motor execution times}
\usage{
delta2delta(model, trees, categories, mappings = 0)

set_deltas_equal(model, trees, categories, mappings = 0)
}
\arguments{
\item{model}{A list of the class \code{ertmpt_model} or \code{drtmpt_model}.}

\item{trees}{Character or numerical vector giving the trees}

\item{categories}{Character or numerical vector identifying category/ies within 
the specified \code{trees} for which the deltas should be changed.}

\item{mappings}{Numerical vector of length \code{length(categories)} providing the mappings. Default is 0.}
}
\value{
A list of the class \code{ertmpt_model}.
}
\description{
Mapping response categories with encoding and motor execution times (deltas). Unlike the processes there are no names for 
  the different deltas and therefore a mapping from response categories to different deltas must be specified.
}
\examples{
###########################################################################
# Detect-Guess variant of the Two-High Threshold model.
# The encoding and motor execution times will be set to different responses 
###########################################################################

mdl_2HTM <- "
# targets
do+(1-do)*g
(1-do)*(1-g)

# lures
(1-dn)*g
dn+(1-dn)*(1-g)

# do: detect old; dn: detect new; g: guess
"

model <- to_ertmpt_model(mdl_file = mdl_2HTM)

## changing the model to have two different encoding and motor execution 
## times for "old" and "new" responses.
new_model <- delta2delta(model = model, trees = c(0, 1), 
                         categories = c(1,3), mappings = c(1,1))
new_model


model <- to_drtmpt_model(mdl_file = mdl_2HTM)

## changing the model to have two different encoding and motor execution 
## times for "old" and "new" responses.
new_model <- delta2delta(model = model, trees = c(0, 1), 
                         categories = c(1,3), mappings = c(1,1))
new_model
                                 

## changing the model to have two different encoding and response execution 
## times for "old" and "new" responses.
new_model <- set_deltas_equal(model = model, trees = c(0, 1), 
                              categories = c(1,3), mappings = c(1,1))
new_model
}
\seealso{
\code{\link{theta2const}}, \code{\link{tau2zero}}, \code{\link{theta2theta}}, and \code{\link{tau2tau}},
}
\author{
Raphael Hartmann
}
