% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_params.R
\name{a2const}
\alias{a2const}
\alias{set_a_const}
\title{Set process threshold to constants}
\usage{
a2const(model, names, constants = NA)

set_a_const(model, names, constants = NA)
}
\arguments{
\item{model}{An object of the class \code{rtmpt_model}.}

\item{names}{Character vector with process names.}

\item{constants}{Numerical vector of length one or \code{length(names)}. You have the following options for the elements of the numeric vector:
\itemize{
 \item \code{0 < constants}: set the named threshold parameter(s) to constant value(s) larger than zero
 \item \code{NA}: estimate the named threshold parameter(s)
}}
}
\value{
An object of the class \code{drtmpt_model}.
}
\description{
Setting process thresholds (a) to constants or change it back to be estimated.
}
\examples{
####################################################################################
# Detect-Guess variant of the Two-High Threshold model.
# The encoding and motor execution times are assumed to be equal for each category.
# The process threshold for guessing (g) will be set to 1.0.
####################################################################################

mdl_2HTM <- "
# targets
do+(1-do)*g
(1-do)*(1-g)

# lures
(1-dn)*g
dn+(1-dn)*(1-g)

# do: detect old; dn: detect new; g: guess
"

model <- to_drtmpt_model(mdl_file = mdl_2HTM)

## setting threshold for g to a constant (1.0):
new_model <- a2const(model = model, names = c("g"), constants = c(1.0))
new_model


## setting threshold of g to a constant (1.0):
new_model <- set_a_const(model = model, names = c("g"), constants = c(1.0))
new_model
}
\seealso{
\code{\link{delta2delta}}, \code{\link{a2a}}, \code{\link{nu2const}}, \code{\link{nu2nu}}, \code{\link{omega2const}} and \code{\link{omega2omega}}
}
\author{
Raphael Hartmann
}
