% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{assert_any_breaker}
\alias{assert_any_breaker}
\title{Assert presence of rule breaker}
\usage{
assert_any_breaker(.tbl, .type = "error", .silent = FALSE, ...)
}
\arguments{
\item{.tbl}{Result of \link[=expose]{exposure}, i.e. data frame with \link{exposure}
attribute.}

\item{.type}{The type of assertion. Can be only one of "error", "warning" or
"message".}

\item{.silent}{If \code{TRUE} no printing of rule breaker information is done.}

\item{...}{Arguments for printing rule breaker information.}
}
\description{
Function to assert if \link[=expose]{exposure} resulted in \link[=any_breaker]{detecting}
some rule breakers.
}
\details{
In case breaker presence this function does the following:
\itemize{
\item In case \code{.silent} is \code{FALSE} print rows from exposure
\link[=ruler-report]{report} corresponding to rule breakers.
\item Make assertion of the chosen \code{.type} about breaker presence in exposure.
\item Return \code{.tbl} (for using inside a \link[magrittr:pipe]{pipe}).
}

If there are no breakers only \code{.tbl} is returned.
}
\examples{
\dontrun{
  mtcars \%>\%
    expose(data_packs(. \%>\% dplyr::summarise(nrow_low = nrow(.) > 50))) \%>\%
    assert_any_breaker()
}
}
\seealso{
\link{any_breaker} for checking of breaker presence in exposure result.

\link{act_after_exposure} for making general actions based in exposure result.
}
