% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soda.R
\name{melb_walk_directional}
\alias{melb_walk_directional}
\title{API using Socrata to Melbourne pedestrian data with directions (per minute)}
\usage{
melb_walk_directional(app_token = NULL)
}
\arguments{
\item{app_token}{Characters giving the application token. A limited number of
requests can be made without an app token (\code{NULL}), but they are subject
to much lower throttling limits than request that do include one. Sign up
for an app token \href{https://data.melbourne.vic.gov.au/profile/app_tokens}{here}.}
}
\value{
A tibble including these variables as follows:
\itemize{
\item \code{sensor_id}: Sensor name
\item \code{date_time}: Date time when the pedestrian counts are recorded
\item \code{date}: Date associated with \code{date_time}
\item \code{time}: Time of day
\item \code{direction_1}: Direction 1 sensor reading (count of pedestrians)
\item \code{direction_2}: Direction 2 sensor reading (count of pedestrians)
\item \code{total_of_directions}: Total sensor reading i.e. direction 1+2 (count of pedestrians)
}
}
\description{
API using Socrata to Melbourne pedestrian data with directions (per minute)
}
\details{
It provides the API using \href{https://dev.socrata.com/foundry/data.melbourne.vic.gov.au/d6mv-s43h}{Socrata},
to access minute by minute directional pedestrian counts for \emph{the last hour}
from pedestrian sensor devices located across the city. The data is updated
every 15 minutes.

Columns \code{sensor_id}, \code{direction_1}, and \code{direction_2} can be used to join
the data with the Sensor Locations dataset which details the location, status,
and directional readings of sensors, which can be obtained from \code{\link[=pull_sensor]{pull_sensor()}}.
}
\examples{
\dontrun{
melb_walk_directional()
}
}
\seealso{
\code{\link[=pull_sensor]{pull_sensor()}}
}
