\name{countriesLow}
\alias{countriesLow}
\docType{data}
\title{ a low resolution world map, a vector map of 244 country boundaries, suitable for zooming in on regions or large global maps }
\description{
A 'SpatialPolygonsDataFrame' [package "sp"] object containing country boundaries derived from Natural Earth data. 
Polygons are attributed with country codes.
}
\usage{data(countriesLow)}
\format{
  The format is:
Formal class 'SpatialPolygonsDataFrame' [package "sp"] with 5 slots
  ..@ data       :'data.frame':	244 obs. of  51 variables:
  .. ..$ ISO3              : Factor w/ 238 levels "-99","ABW","AFG",..: 1 1 1 1 1 1 2 3 4 5 ...
  .. ..$ ScaleRank         : int [1:244] 1 1 1 5 1 1 3 1 1 1 ...
  .. ..$ LabelRank         : int [1:244] 1 1 1 5 1 1 3 1 1 1 ...
  .. ..$ FeatureCla        : Factor w/ 2 levels "Admin-0 countries",..: 1 1 1 1 1 1 1 1 1 1 ...
  .. ..$ SOVEREIGNT        : Factor w/ 204 levels "Afghanistan",..: 91 130 87 10 198 164 124 1 5 189 ...
  .. ..$ SOV_A3            : Factor w/ 205 levels "AFG","AGO","ALB",..: 98 44 90 10 154 164 133 1 2 64 ...
  .. ..$ ADM0_DIF          : num [1:244] 0 0 1 1 0 0 1 0 0 1 ...
  .. ..$ LEVEL             : num [1:244] 2 2 2 2 2 2 2 2 2 2 ...
  .. ..$ TYPE              : Factor w/ 7 levels "Country","County",..: 6 6 5 3 4 4 1 6 6 3 ...
  .. ..$ ADMIN             : Factor w/ 253 levels "Afghanistan",..: 114 158 192 98 239 200 13 1 7 8 ...
  .. ..$ ADM0_A3           : Factor w/ 253 levels "ABW","AFG","AGO",..: 121 55 113 101 186 198 1 2 3 4 ...
  .. ..$ GEOU_DIF          : num [1:244] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ GEOUNIT           : Factor w/ 253 levels "Afghanistan",..: 114 158 192 98 239 200 13 1 7 8 ...
  .. ..$ GU_A3             : Factor w/ 253 levels "ABW","AFG","AGO",..: 121 55 113 101 186 198 1 2 3 4 ...
  .. ..$ SU_DIF            : num [1:244] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ SUBUNIT           : Factor w/ 253 levels "Afghanistan",..: 114 158 192 98 239 200 13 1 7 8 ...
  .. ..$ SU_A3             : Factor w/ 253 levels "ABW","AFG","AGO",..: 121 55 113 101 186 198 1 2 3 4 ...
  .. ..$ NAME              : Factor w/ 250 levels "Afghanistan",..: 115 148 NA 99 236 198 13 1 7 8 ...
  .. ..$ ABBREV            : Factor w/ 247 levels "A.C.Is.","Afg.",..: 114 145 NA 97 233 191 13 2 8 8 ...
  .. ..$ POSTAL            : Factor w/ 240 levels "A","AE","AF",..: 112 43 NA 99 229 190 14 3 8 5 ...
  .. ..$ NAME_FORMA        : Factor w/ 196 levels "Aland Islands",..: NA NA NA NA NA 143 NA 43 74 NA ...
  .. ..$ TERR_             : Factor w/ 15 levels "Assoc. with N.Z.",..: NA NA NA 2 7 NA 11 NA NA 12 ...
  .. ..$ NAME_SORT         : Factor w/ 253 levels "Afghanistan",..: 119 57 113 100 239 202 13 1 7 8 ...
  .. ..$ MAP_COLOR         : num [1:244] 11 8 0 7 4 2 9 7 1 3 ...
  .. ..$ POP_EST           : num [1:244] 1804838 265100 6000 4000 -99 ...
  .. ..$ GDP_MD_EST        : num [1:244] 5352 3600 0 0 900 ...
  .. ..$ FIPS_10_          : num [1:244] 0 -99 -99 -99 -99 -99 0 0 0 0 ...
  .. ..$ ISO_A2            : Factor w/ 237 levels "-99","AD","AE",..: 1 1 1 1 1 1 15 4 9 6 ...
  .. ..$ ISO_A3            : Factor w/ 238 levels "-99","ABW","AFG",..: 1 1 1 1 1 1 2 3 4 5 ...
  .. ..$ ISO_N3            : num [1:244] -99 -99 -99 -99 -99 -99 533 4 24 660 ...
  .. ..$ ISO2              : Factor w/ 222 levels "AD","AE","AF",..: NA NA NA NA NA NA 14 3 9 5 ...
  .. ..$ Name              : Factor w/ 232 levels "Afghanistan",..: NA NA NA NA NA NA 11 1 6 7 ...
  .. ..$ FIPS              : Factor w/ 222 levels "AA","AC","AE",..: NA NA NA NA NA NA 1 4 10 15 ...
  .. ..$ Numeric           : num [1:244] NA NA NA NA NA NA 533 4 24 660 ...
  .. ..$ GEO3major         : Factor w/ 6 levels "Africa","Asia and the Pacific",..: NA NA NA NA NA NA 5 3 2 5 ...
  .. ..$ GEO3              : Factor w/ 23 levels "Arabian Peninsula",..: NA NA NA NA NA NA 4 16 19 4 ...
  .. ..$ IMAGE24           : Factor w/ 25 levels "Asia-Stan","Brazil",..: NA NA NA NA NA NA 16 8 20 16 ...
  .. ..$ GLOCAF            : Factor w/ 19 levels "Brazil","Canada",..: NA NA NA NA NA NA 12 14 17 12 ...
  .. ..$ Stern             : Factor w/ 13 levels "Australasia",..: NA NA NA NA NA NA 2 4 11 2 ...
  .. ..$ SRESmajor         : Factor w/ 4 levels "ALM","ASIA","OECD90",..: NA NA NA NA NA NA 1 2 1 1 ...
  .. ..$ SRES              : Factor w/ 11 levels "Central and Eastern Europe (EEU)",..: NA NA NA NA NA NA 3 9 10 3 ...
  .. ..$ GBD               : Factor w/ 21 levels "Asia Pacific, High Income",..: NA NA NA NA NA NA 7 4 18 7 ...
  .. ..$ AVOIDnumeric      : num [1:244] NA NA NA NA NA NA 28 21 24 28 ...
  .. ..$ AVOIDname         : Factor w/ 30 levels "Australia","Brazil",..: NA NA NA NA NA NA 4 19 27 4 ...
  .. ..$ Vulnerability.Name: Factor w/ 234 levels "Afghanistan",..: NA NA NA NA NA NA 11 1 6 7 ...
  .. ..$ GIS.Country       : Factor w/ 234 levels "Afghanistan",..: NA NA NA NA NA NA 11 1 6 7 ...
  .. ..$ CNTRY_NAME        : Factor w/ 233 levels "Afghanistan",..: NA NA NA NA NA NA 11 1 6 7 ...
  .. ..$ GMI_CNTRY         : Factor w/ 225 levels "ABW","AFG","AGO",..: NA NA NA NA NA NA 1 2 3 4 ...
  .. ..$ LDC               : Factor w/ 2 levels "LDC","other": NA NA NA NA NA NA 2 1 1 2 ...
  .. ..$ SID               : Factor w/ 2 levels "other","SID": NA NA NA NA NA NA 2 1 1 2 ...
  .. ..$ LLDC              : Factor w/ 2 levels "LLDC","other": NA NA NA NA NA NA 2 1 2 2 ...
  ..@ polygons   :List of 243

  ..@ plotOrder  : int [1:243] 12 184 39 227 42 33 16 88 114 9 ...
  ..@ bbox       : num [1:2, 1:2] -180 -90 180 83.6
  .. ..- attr(*, "dimnames")=List of 2
  .. .. ..$ : chr [1:2] "x" "y"
  .. .. ..$ : chr [1:2] "min" "max"
  ..@ proj4string:Formal class 'CRS' [package "sp"] with 1 slots
  .. .. ..@ projargs: chr NA
}
\details{
Derived fron version 1.4.0 of Natural Earth data 1:50 m data.      

The different country boundaries in rworldmap are processed from Natural Earth Data as follows :
All :         
~ rename any non-ASCII country names that cause R trouble
~ rename Curacao which is particularly troublesome !
~ check polygon geometries using checkPolygonsHoles 
~ set projections, e.g. proj4string(countriesCoarse) <- CRS("+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
~ set polygon IDs to country names (from ADMIN field)
~ copy ISO_A3 to ISO3
~ replace missing ISO3 codes (6 in this version) with ADM0_A3
~ check for duplicate ISO3 codes (2 in this version)
~ set ISO3 for Gaza to Gaza and 'Ashmore and Cartier Islands' to Ashm
~ replace POP_EST of -99 with NA
~ join on countryRegions data

countriesCoarseLessIslands :  ne_110
countriesCoarse : ne_110 plus extra countries from ne_50 plus Tuvalu from ne_10
countriesLow :    ne_50 plus Tuvalu from ne_10
countriesHigh (in package rworldxtra) :   ne_10

}
\source{
http://www.naturalearthdata.com/downloads/50m-cultural-vectors/
}
\examples{
data(countriesLow)
}
\keyword{datasets}
