% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.trees.R
\name{load.trees}
\alias{load.trees}
\title{Custom functions to load tree lists so that rwty can do basic processing on the way in.}
\usage{
load.trees(file, type = NA, format = "mb", gens.per.tree = NA, trim = 1,
  logfile = NA, skip = NA)
}
\arguments{
\item{file}{A path to a tree file containing an MCMC chain of trees}

\item{type}{An argument that designates the type of tree file.  If "nexus",
trees are loaded using ape's read.nexus function.  Otherwise, it's read.tree.
If a "format" argument is passed, type will be determined from the format definition.}

\item{format}{File format, which is used to find tree and log files.
Currently accepted values are "mb" for MrBayes, "beast" for BEAST, and "*beast" for *BEAST.
If you would like RWTY to understand additional formats, please contact the authors and send us some sample data.}

\item{gens.per.tree}{The number of generations separating trees.  If not provided, RWTY will attempt to calculate it automatically.}

\item{trim}{Used for thinning the chain.  If a number N is provided, RWTY keeps every Nth tree.}

\item{logfile}{A path to a file containing model parameters and likelihoods.  If no path is provided but
a "format" argument is supplied, RWTY will attempt to find the log file automatically based on the format
definition.}

\item{skip}{The number of lines that must be skipped to get to the header of the log file.
MrBayes, for instance, prints a comment line at the top of the log file, so MrBayes files should be
read in with a skip value of 1.  If no "skip" value is provided but a "format" is supplied, RWTY will 
attempt to read logs using the skip value from the format definition.}
}
\value{
output An rwty.trees object containing the multiPhylo and the table of values from the log file if available.
}
\description{
Loads trees, looks for a log file of tree likelihoods and parameter values, returns an rwty.trees object containing both
}
\examples{
#load.trees(file="mytrees.t", format = "mb")
}
\keyword{MCMC,}
\keyword{Phylogenetics,}
\keyword{load}

