% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeplot.splitfreqs.sliding.R
\name{makeplot.splitfreqs.sliding}
\alias{makeplot.splitfreqs.sliding}
\title{Plot split frequencies in sliding windows over the course of an MCMC}
\usage{
makeplot.splitfreqs.sliding(chains, burnin = 0, n.clades = 20,
  window.size = 20, facet = TRUE, rank = "ess")
}
\arguments{
\item{chains}{A list of rwty.trees objects.}

\item{burnin}{The number of trees to eliminate as burnin}

\item{n.clades}{The number of clades to plot}

\item{window.size}{The number of trees to include in each window (note, specified as a number of sampled trees, not a number of generations)}

\item{facet}{(TRUE/FALSE). TRUE: return a single plot with one facet per chain; FALSE: return a list of individual plots with one plot per chain}

\item{rank}{('ess', 'sd'). How to rank the clades? By default, we plot the 20 'worst' clades. This parameter sets the definition of 'worst'. The default is to rank the clades by increasing Effective Sample Size (i.e. the 20 worst clades are those with the lowest ESS), since in a sliding window plot we expect well-sampled splits to have a high value (rank = "ess").  The original AWTY ranked clades by their standard deviations. To do this, just set rank = 'sd'.}
}
\value{
splitfreqs.plot Either a single ggplot2 object or a list of ggplot2 objects.
}
\description{
Takes a list of rwty.trees objects.  
Plots the split frequencies of clades over the course of the MCMC, calculated from windows of a specified size.
Only plots the n.clades most variable clades, as measured by the standard deviation of the split frequencies of each clade across the MCMC.  
Each line in the plot represents a single clade. The colour of the line represents the standard deviation of the split frequencies of that clade across the MCMC.
}
\examples{
data(fungus)
makeplot.splitfreqs.sliding(fungus, burnin = 20, n.clades=25)
}
\keyword{mcmc,}
\keyword{phylogenetics,}
\keyword{plot}
\keyword{sliding}
\keyword{window,}

