% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utils.r
\name{rowMeans2}
\alias{rowMeans2}
\title{Form row means taking into account a minimum number of values required}
\usage{
rowMeans2(x, w, min = 0, na.rm = TRUE)
}
\arguments{
\item{x}{A matrix of dataframe whose columns should be averaged.}

\item{w}{A numerical vector of weights the same length as number of columns
in \code{x}.}

\item{min}{The minimum number of values required to calculate the mean value.
Otherwise return \code{NA}.}

\item{na.rm}{A logical value indicating whether \code{NA} values in \code{x}
should be stripped before the computation proceeds.}
}
\value{
A vector of means.
}
\description{
In the construction of psychometric scales the calculation of a value is
sometimes only desired if a minimum number of items contain values. In SPSS
it is possible to calculate a mean value only if a minimum number of values
are supplied by using the syntax MEAN.MIN with MIN being a numeric value. The
function \code{rowMeans2} does the same.
}
\details{
\code{rowMeans2} is very similary to \code{rowMeans}. The differences are
that \code{rowMeans2} allows to indicate the minimum number of values that
have to be supplied and to weight the columns.
}
\examples{
x <- replicate(3, runif(5))
 x[1:3, 1] <- NA       # add NAs to data
 x[1:2, 2] <- NA
 x[1, 3] <- NA
 x
 rowMeans2(x)          # the same as rowMeans, except that NAs are allowed
 rowMeans2(x, min=2)   # minimum two values to calculate mean
 rowMeans2(x, min=3)   # minimum three values to calculate mean

 # returns numeric(0) if x has zero rows
 d <- x[NULL, ]
 rowMeans2(d)

 # weights for each column
 rowMeans2(x, w=c(1,1,2))
}
\author{
Mark Heckmann
}
\seealso{
\code{\link{rowMeans}}
}

