require(s20x)
drug.trial<-matrix(c(35,70,95,62,76,62,88,80,32),byrow=T,nr=3,nc=3)
rownames(drug.trial)<-c("Placebo","Single","Double")
colnames(drug.trial)<-c("Improve","NoChange","Worse")
drug.trial
chisq.test(drug.trial)
rowdistr(drug.trial)
rowdistr(drug.trial,comp="between")

data (course.df)
diffs<-course.df$Assign-course.df$Test
stripchart(diffs,pch=1,method="stack",main="Assignment score - Test score",xlab="differences")
summaryStats(diffs)
normcheck(diffs)
t.test(course.df$Assign,course.df$Test,paired=T)

data (course.df)
stripchart(Exam~Attend,pch=1,method="stack", ylab="regularly attend",xlab="exam mark",main="Exam by Attend",data=course.df)
summaryStats(Exam~Attend,data=course.df)
exam.fit<-lm(Exam~Attend,data=course.df)
eovcheck(exam.fit)
normcheck(exam.fit)
t.test(Exam~Attend,var.equal=T,data=course.df)

data (incomes.df)
boxplot(incomes.df$incomes,main="Boxplot of Incomes")
summaryStats(incomes.df$incomes)
normcheck(incomes.df$incomes)
log.incomes<-log(incomes.df$incomes)
boxplot(log.incomes,main="Boxplot of (log) incomes")
summaryStats(log.incomes)
normcheck(log.incomes)
t.test(log.incomes)
c.i.<-t.test(log.incomes)$conf.int
c.i.
exp(c.i.)

data (rain.df)
rain.df
layout20x(1,2)
stripchart(rain~seed,pch=1,vert=T,ylab="rain",main="Stripcharts of Seeding",data=rain.df)
boxplot(rain~seed,ylab="rain",main="Boxplots of Seeding",data=rain.df)
summaryStats(rain~seed,data=rain.df)
rain.fit<-lm(rain~seed,data=rain.df)
eovcheck(rain.fit)
rain.df<-within(rain.df,{log.rain<-log(rain)})
rain.df[1,]
boxplot(log.rain~seed,ylab="(log) rain",main="Boxplots of (log) Seeding",data=rain.df)
summaryStats(log.rain~seed,data=rain.df)
rain.fit1<-lm(log.rain~seed,data=rain.df)
eovcheck(rain.fit1)
normcheck(rain.fit1)
t.test(log.rain~seed,var.equal=T,data=rain.df)
c.i.<-t.test(log.rain~seed,var.equal=T, data=rain.df)$conf.int
c.i.
exp(c.i.)

data (fire.df)
fire.df
plot(damage~distance,main="Damage versus distance",data=fire.df)
fire.fit<-lm(damage~distance,data=fire.df)
eovcheck(fire.fit)
summary(fire.fit)
plot(fire.fit,which=1)
normcheck(fire.fit)
ciReg(fire.fit)
fire.predict<-data.frame(c(1,4))
predict20x(fire.fit,fire.predict)

data (diamonds.df)
diamonds.df
plot(price~weight,main="Price versus weight of diamonds",data=diamonds.df)
diamond.fit<-lm(price~weight,data=diamonds.df)
eovcheck(diamond.fit)
summary(diamond.fit)
layout20x(1,2)
plot(diamond.fit,which=1)
plot(residuals(diamond.fit)~diamonds.df$weight,main="Residual plot (weight)")
layout20x(1,1)
normcheck(diamond.fit)
ciReg(diamond.fit)
diamond.predict<-data.frame(c(0.3,1.2))
predict20x(diamond.fit,diamond.predict)

data (camplake.df)
camplake.df
trendscatter(Length~Scale.Radius,data=camplake.df)
bluegill.fit<-lm(Length~Scale.Radius,data=camplake.df)
summary(bluegill.fit)
residPlot(bluegill.fit)
bluegill.fit1<-lm(Length~Scale.Radius+I(Scale.Radius^2),data=camplake.df)
residPlot(bluegill.fit1)
eovcheck(bluegill.fit1)
normcheck(bluegill.fit1)
sr<-seq(1.3,3.6,by=0.01)
l<-bluegill.fit1$coef[1]+ bluegill.fit1$coef[2]*sr+ (bluegill.fit1$coef[3]*(sr^2))
plot(l~sr,type="l",main="Fitted Model",xlab="Scale.Radius",ylab="Length")
points(camplake.df$Scale.Radius,camplake.df$Length)
trendscatter(Length~Age,data=camplake.df)
bluegill.fit<-lm(Length~Age,data=camplake.df)
summary(bluegill.fit)
residPlot(bluegill.fit,f=0.75)
eovcheck(bluegill.fit)
normcheck(bluegill.fit)
ciReg(bluegill.fit)

data (bursary.df)
bursary.df
plot(pass.rate~decile,main="Pass rate versus decile",data=bursary.df)
trendscatter(pass.rate~decile,f=0.95,data=bursary.df)
bursary.fit<-lm(pass.rate~decile,data=bursary.df)
residPlot(bursary.fit,f=0.95)
bursary.df<-within(bursary.df,{fail.rate<-100-pass.rate})
bursary.fit1<-lm(fail.rate~decile,data=bursary.df)
residPlot(bursary.fit1,f=0.95)
bursary.fit2<-lm(log(fail.rate)~decile,data=bursary.df)
residPlot(bursary.fit2,f=0.95)
eovcheck(bursary.fit2)
normcheck(bursary.fit2)
summary(bursary.fit2)
exp(ciReg(bursary.fit2))

data (mazda.df)
mazda.df<-within(mazda.df,{age<-91-year})
plot(price~age,main="Mazda Car Prices",data=mazda.df)
trendscatter(price~age,data=mazda.df)
trendscatter(log(price)~age,data=mazda.df)
mazda.fit<-lm(log(price)~age,data=mazda.df)
residPlot(mazda.fit)
eovcheck(mazda.fit)
normcheck(mazda.fit)
summary(mazda.fit)
exp(ciReg(mazda.fit))

data (lakemary.df)
lakemary.df
trendscatter(Length~Age,data=lakemary.df)
bluegill.fit<-lm(Length~Age,data=lakemary.df)
residPlot(bluegill.fit)
bluegill.fit1<-lm(Length~Age+I(Age^2),data=lakemary.df)
residPlot(bluegill.fit1)
eovcheck(bluegill.fit1)
normcheck(bluegill.fit1)
summary(bluegill.fit1)
a<-seq(1,6,by=0.01)
l<- bluegill.fit1$coef[1]+ bluegill.fit1$coef[2]*a+(bluegill.fit1$coef[3]*(a^2))
plot(a,l,type="l",main="Fitted Model",xlab="Age",ylab="Length")
points(lakemary.df$Age,lakemary.df$Length)

data (body.df)
ethbod<-crosstabs(~ethnicity+factor(bodyim,levels=c("slight.uw","right","slight.ow","mod.ow","very.ow")),data=body.df)
ethbod$exp
fisher.test(body.df$ethnicity,body.df$bodyim,simulate.p.value=T,B=1e5,alternative="greater")
rowdistr(ethbod)
rowdistr(ethbod,comp="between")

data (thyroid.df)
thyroid.df
plot(thyroid~body,main="Thyroid weight versus body weight (by group)",type="n",data=thyroid.df)
text(thyroid.df$body,thyroid.df$thyroid, thyroid.df$group)
thyroid.df<-within(thyroid.df,{group1.<-factor(group)})
thyroid.fit<-lm(thyroid~body+group1.,data=thyroid.df)
summary(thyroid.fit)
eovcheck(thyroid.fit)
plot(thyroid.fit,which=1)
thyroid.fit1<-lm(thyroid~body+I(body^2)+group1.,data=thyroid.df)
summary(thyroid.fit1)
normcheck(thyroid.fit)
ciReg(thyroid.fit)
plot(thyroid~body,main="Fitted lines",type="n",data=thyroid.df)
text(thyroid.df$body,thyroid.df$thyroid,thyroid.df$group1)
abline(thyroid.fit$coef[1],thyroid.fit$coef[2])
abline(thyroid.fit$coef[1]+ thyroid.fit$coef[3],thyroid.fit$coef[2])

data (teach.df)
teach.df
plot(lang~IQ,main="Language Score versus IQ (by method)",type="n",data=teach.df)
text(teach.df$IQ,teach.df$lang,teach.df$method)
teach.df<-within(teach.df,{method1.<-factor(method)})
teach.fit<-lm(lang~IQ+method1.,data=teach.df)
summary(teach.fit)
eovcheck(teach.fit)
plot(teach.fit,which=1)
normcheck(teach.fit)
ciReg(teach.fit)
teach.df<-within(teach.df,{method2.<-factor(method,levels=c(2,1,3))})
teach.fit1<-lm(lang~IQ+method2.,data=teach.df)
summary(teach.fit1)
ciReg(teach.fit1)
plot(lang~IQ,main="Fitted lines",type="n",data=teach.df)
text(teach.df$IQ,teach.df$lang,teach.df$method)
abline(teach.fit$coef[1],teach.fit$coef[2])
abline(teach.fit$coef[1]+teach.fit$coef[3], teach.fit$coef[2])
abline(teach.fit$coef[1]+teach.fit$coef[4], teach.fit$coef[2])

data (camplake.df)
camplake.df<-within(camplake.df,{Age.F<-factor(Age)})
plot(Length~Scale.Radius,type="n",main="Length vs Scale radius (by Age)",data=camplake.df)
text(camplake.df$Scale.Radius,camplake.df$Length, camplake.df$Age.F)
bluegill.fit<-lm(Length~Scale.Radius+Age.F, data=camplake.df)
eovcheck(bluegill.fit)
residPlot(bluegill.fit,f=0.7)
normcheck(bluegill.fit)
summary(bluegill.fit)
ciReg(bluegill.fit)

data (peru.df)
pairs20x(peru.df[c(5,1:4)])
peru.fit<-lm(BP~age+years+weight+height,data=peru.df)
eovcheck(peru.fit)
plot(peru.fit,which=1)
summary(peru.fit)
residPlot(peru.fit,f=0.95)
layout20x(1,2)
plot(residuals(peru.fit)~years,main="Residual plot (years)",data=peru.df)
lines(lowess(peru.df$years,residuals(peru.fit),f=0.8))
plot(residuals(peru.fit)~weight,main="Residual plot (weight)",data=peru.df)
lines(lowess(peru.df$weight,residuals(peru.fit),f=0.8))
layout20x(1,1)
peru.fit1<-lm(BP~age+years+I(years^2)+weight+height,data=peru.df)
summary(peru.fit1)
residPlot(peru.fit1,f=0.95)
normcheck(peru.fit1)
cooks20x(peru.fit1)
peru.fit2<-lm(BP~age+years+I(years^2)+weight+height,data=peru.df[-1,],)
summary(peru.fit2)
peru.fit3<-lm(BP~age+years+I(years^2)+weight+height,data=peru.df[-c(1,37),])
summary(peru.fit3)
summary(peru.fit1)
summary(peru.fit2)
summary(peru.fit3)
plot(peru.fit3,which=1)
normcheck(peru.fit3)
ciReg(peru.fit3)
yrs<-seq(0,45,by=0.01)
bp<- -1.76743*yrs+(0.03225*(yrs^2))
plot(yrs,bp,type="l",main="BP versus Years",xlab="years",ylab="BP")
abline(v=27)

data (camplake.df)
pairs20x(camplake.df[c(3,1:2)])
bluegill.fit<-lm(Length~Age+Scale.Radius,data=camplake.df)
eovcheck(bluegill.fit)
bluegill.fit1<-lm(log(Length)~Age+Scale.Radius,data=camplake.df)
eovcheck(bluegill.fit1)
plot(bluegill.fit1,which=1)
layout20x(1,2)
plot(residuals(bluegill.fit1)~Age,main="Residual plot (Age)",data=camplake.df)
plot(residuals(bluegill.fit1)~Scale.Radius,main="Residual plot (Scale Radius)",data=camplake.df)
layout20x(1,1)
bluegill.fit2<-lm(log(Length)~Age+I(Age^2)+ Scale.Radius,data=camplake.df)
summary(bluegill.fit2)
plot(bluegill.fit2,which=1)
normcheck(bluegill.fit2)
cooks20x(bluegill.fit2)
exp(ciReg(bluegill.fit2))

data (course.df)
pairs20x(course.df[c(3,7,8,14)])
exam.fit<-lm(Exam~Assign+Test+Stage1+Gender+Attend+Years.Since+Repeat+Degree,data=course.df)
eovcheck(exam.fit)
plot(exam.fit,which=1)
summary(exam.fit)
anova(exam.fit)
exam.fit1<-lm(Exam~Assign+Test+Stage1+Gender+Attend+Years.Since+Repeat,data=course.df)
summary(exam.fit1)
exam.fit2<-lm(Exam~Assign+Test+Stage1+Gender+Attend+Repeat,data=course.df)
summary(exam.fit2)
exam.fit3<-lm(Exam~Assign+Test+Stage1+Attend+Repeat,data=course.df)
summary(exam.fit3)
exam.fit4<-lm(Exam~Assign+Test+Stage1+Repeat, data=course.df)
summary(exam.fit4)
exam.fit5<-lm(Exam~Assign+Test+Stage1,data=course.df)
summary(exam.fit5)
plot(exam.fit5,which=1)
layout20x(1,2)
plot(residuals(exam.fit5)~Assign,main="Residual plot (Assign)",data=course.df)
lines(lowess(course.df$Assign,residuals(exam.fit5)))
plot(residuals(exam.fit5)~Test,main="Residual plot (Test)",data=course.df)
lines(lowess(course.df$Test,residuals(exam.fit5)))
layout20x(1,1)
exam.fit6<-lm(Exam~Assign+Test+I(Test^2)+Stage1,data=course.df)
summary(exam.fit6)
plot(exam.fit6,which=1)
cooks20x(exam.fit6)
course.df[106,]
course.df<-within(course.df,{obs<-1:146})
plot(Test~Assign,type="n",main="Test versus Assign",data=course.df)
text(course.df$Assign,course.df$Test,course.df$obs)
exam.fit7<-lm(Exam~Assign+Test+I(Test^2)+Stage1,data=course.df[-106,])
summary(exam.fit7)
summary(exam.fit6)
normcheck(exam.fit6)
ciReg(exam.fit6)
course.df<-within(course.df,{Stage1B.<-factor(Stage1,levels=c("B","C","A"))})
exam.fit6a<-lm(Exam~Assign+Test+I(Test^2)+Stage1B.,data=course.df)
summary(exam.fit6a)
ciReg(exam.fit6a)
test<-seq(4,20,by=0.01)
exam<- -1.2472*test+(0.13846*(test^2))
plot(exam~test,type="l",main="Exam versus Test",xlab="test",ylab="exam")

data (technitron.df)
technitron.df
pairs(technitron.df[c(1:4,6:8)])
pairs20x(technitron.df[c(1:4,8)])
technitron.df<-within(technitron.df,{dept1.<-factor(dept)})
tech.fit<-lm(salary~yrs.empl+prior.yrs+educ+gender+ super+dept1.,data=technitron.df)
eovcheck(tech.fit)
tech.fit1<-lm(log(salary)~yrs.empl+prior.yrs+educ+ gender+super+dept1.,data=technitron.df)
plot(tech.fit1,which=1)
summary(tech.fit1)
tech.fit2<-lm(log(salary)~yrs.empl+prior.yrs+educ+ gender+dept1.,data=technitron.df)
summary(tech.fit2)
tech.fit3<-lm(log(salary)~yrs.empl+educ+gender+dept1., data=technitron.df)
summary(tech.fit3)
plot(tech.fit3,which=1)
cooks20x(tech.fit3)
normcheck(tech.fit3)
exp(ciReg(tech.fit3,conf.level=0.9))

data (zoo.df)
zoo.df
pairs20x(zoo.df[c(2,1,3,6)])
stripchart(attendance~nice.day,vert=T,pch=1,method="jitter",main="Attendance by nice day",data=zoo.df)
stripchart(attendance~day.type,vert=T,pch=1,method="jitter",main="Attendance by day type",data=zoo.df)
zoo.df<-within(zoo.df,{day.type1.<-factor(day.type)})
zoo.fit<-lm(attendance~time+sun.yesterday+tv.ads+nice.day+day.type1.,data=zoo.df)
eovcheck(zoo.fit)
plot(residuals(zoo.fit)~fitted(zoo.fit),type="n",main="Residual plot (fitted) by day type")
text(fitted(zoo.fit),residuals(zoo.fit),zoo.df$day.type1.)
zoo.fit1<-lm(log(attendance)~time+sun.yesterday+tv.ads+nice.day+day.type1.,data=zoo.df)
plot(residuals(zoo.fit1)~fitted(zoo.fit1),type="n",main="Residual plot (fitted) by day type")
text(fitted(zoo.fit1),residuals(zoo.fit1),zoo.df$day.type1.)
summary(zoo.fit1)
cooks20x(zoo.fit1)
normcheck(zoo.fit1)
exp(ciReg(zoo.fit1))

data (course.df)
stripchart(Exam~Stage1,pch=1,method="stack",main="Exam mark by Stage 1",ylab="grade in 10x",xlab="20x exam mark",data=course.df)
summaryStats(Exam~Stage1,data=course.df)
exam.fit<-lm(Exam~Stage1,data=course.df)
eovcheck(exam.fit)
normcheck(exam.fit)
summary1way(exam.fit)
multipleComp(exam.fit)

data (computer.df)
computer.df
computer.df<-within(computer.df,{selfassess1.<-factor(selfassess)})
stripchart(score~selfassess1.,pch=1,vert=T,main="Stripcharts of Selfassess",ylab="score", data=computer.df)
summaryStats(score~selfassess1.,data=computer.df)
computer.fit<-lm(score~selfassess1.,data=computer.df)
eovcheck(computer.fit)
normcheck(computer.fit)
summary1way(computer.fit)
multipleComp(computer.fit)

salestable<-c(34,21,44,52,37,42)
names(salestable)<-c("A","B","C","D","E","F")
salestable
sales.output<-freq1way(salestable)

data (oysters.df)
boxplot(Oysters~Site,ylab="Number of Oysters",main="Boxplot of Oysters by Site",data=oysters.df)
oyster.fit<-lm(Oysters~Site,data=oysters.df)
eovcheck(oyster.fit)
oyster.fit<-lm(log(Oysters)~Site,data=oysters.df)
eovcheck(oyster.fit)
normcheck(oyster.fit)
summary1way(oyster.fit)
multipleComp(oyster.fit)

data (fruitfly.df)
boxplot(fecundity~strain,main="Boxplots of fecundity by strain",ylab="fecundity",xlab="strain",data=fruitfly.df)
summaryStats(fecundity~strain,data=fruitfly.df)
fruitfly.fit<-lm(fecundity~strain,data=fruitfly.df)
eovcheck(fruitfly.fit)
normcheck(fruitfly.fit)
summary1way(fruitfly.fit)
multipleComp(fruitfly.fit)

data (books.df)
boxplot(length~book,main="Sentence length by book",xlab="book",ylab="length",data=books.df)
book.fit<-lm(length~book,data=books.df)
eovcheck(book.fit)
normcheck(book.fit)
book.fit1<-lm(log(length)~book,data=books.df)
eovcheck(book.fit1)
normcheck(book.fit1)
summary1way(book.fit1)
multipleComp(book.fit1)

data (skulls.df)
boxplot(measurement~year,main="Skull measurements by year",xlab="year",ylab="skull measurement", data=skulls.df)
summaryStats(measurement~year,data=skulls.df)
skulls.df<-within(skulls.df,{year.F<-factor(year)})
skull.fit<-lm(measurement~year.F,data=skulls.df)
eovcheck(skull.fit)
normcheck(skull.fit)
summary1way(skull.fit)
multipleComp(skull.fit)

data (apples.df)
boxplot(Weight~Rootstock,main="Apple tree weight by rootstock",ylab="weight",xlab="rootstock",data=apples.df)
summaryStats(Weight~Rootstock,data=apples.df)
boxplot(Weight~Propagated,main="Apple tree weight by propagation",ylab="weight",xlab="propagation",data=apples.df)
summaryStats(Weight~Propagated,data=apples.df)
propagation.fit<-lm(Weight~Propagated,data=apples.df)
eovcheck(propagation.fit)
normcheck(propagation.fit)
summary(propagation.fit)
ciReg(propagation.fit)
summary1way(propagation.fit)
multipleComp(propagation.fit)
t.test(Weight~Propagated,data=apples.df,var.equal=T)

data (nail.df)
boxplot(dry~polish,main="Drying times by polish",xlab="polish",ylab="time in seconds",data=nail.df)
summaryStats(dry~polish,data=nail.df)
nail.fit<-lm(dry~polish,data=nail.df)
eovcheck(nail.fit)
normcheck(nail.fit)
t.test(dry~polish,var.equal=F,data=nail.df)

data (course2way.df)
interactionPlots(Exam~Gender+Attend, data=course2way.df)
exam.fit<-lm(Exam~Gender+Attend+Gender*Attend,data=course2way.df)
eovcheck(exam.fit)
summary2way(exam.fit,page="table")
exam.fit1<-lm(Exam~Gender+Attend,data=course2way.df)
summary2way(exam.fit1,page="table")
exam.fit2<-lm(Exam~Attend,data=course2way.df)
eovcheck(exam.fit2)
normcheck(exam.fit2)
summary1way(exam.fit2)
multipleComp(exam.fit2)

data (soyabean.df)
interactionPlots(yield~cultivar+planttime,data=soyabean.df)
interactionPlots(yield~planttime+cultivar,data=soyabean.df)
soya.fit<-lm(yield~cultivar+planttime+ cultivar*planttime,data=soyabean.df)
eovcheck(soya.fit)
summary2way(soya.fit,page="table")
soya.fit1<-lm(yield~cultivar+planttime,data=soyabean.df)
eovcheck(soya.fit1)
normcheck(soya.fit1)
summary2way(soya.fit1,page="table")
summary2way(soya.fit1,page="nointeraction")

data (arousal.df)
arousal.df
interactionPlots(arousal~picture+gender,data=arousal.df)
interactionPlots(arousal~gender+picture,data=arousal.df)
arousal.fit<-lm(arousal~gender+picture+gender*picture,data=arousal.df)
eovcheck(arousal.fit)
summary2way(arousal.fit,page="table")
normcheck(arousal.fit)
summary2way(arousal.fit,page="interaction")
gender.picture<-crossFactors(arousal.df$gender,arousal.df$picture)
gender.picture<-factor(gender.picture)
arousal.1way.fit<-lm(arousal.df$arousal~gender.picture)
summary1way(arousal.1way.fit)
multipleComp(arousal.1way.fit)

data (butterfat.df)
interactionPlots(Butterfat~Breed+Age,data=butterfat.df)
butterfat.fit<-lm(Butterfat~Breed+Age+Breed*Age,data=butterfat.df)
eovcheck(butterfat.fit)
summary2way(butterfat.fit,page="table")
butterfat.fit1<-lm(Butterfat~Breed+Age,data=butterfat.df)
summary2way(butterfat.fit1,page="table")
butterfat.fit2<-lm(Butterfat~Breed,data=butterfat.df)
eovcheck(butterfat.fit2)
butterfat.fit3<-lm(log(Butterfat)~Breed,data=butterfat.df)
eovcheck(butterfat.fit3)
normcheck(butterfat.fit3)
summary1way(butterfat.fit3)
multipleComp(butterfat.fit3)

pheno.table<-c(926,288,293,104)
names(pheno.table)<-c("tall-cut","tall-pot","dwarf-cut","dwarf-pot")
pheno.table
freq1way(pheno.table,c(9/16,3/16,3/16,1/16))

data (seeds.df)
interactionPlots(Count~Water+Light,data=seeds.df)
seeds.df<-within(seeds.df,{Water.F<-factor(Water)})
seed.fit<-lm(Count~Water.F+Light+Water.F*Light,data=seeds.df)
eovcheck(seed.fit)
summary2way(seed.fit,page="table")
normcheck(seed.fit)
summary2way(seed.fit,page="interaction")
interactionPlots(Count~Light+Water,data=seeds.df)

data (sheep.df)
interactionPlots(Weight~Copper+Cobalt,data=sheep.df)
sheep.fit<-lm(Weight~Copper+Cobalt+Copper*Cobalt,data=sheep.df)
eovcheck(sheep.fit)
summary2way(sheep.fit,page="table")
sheep.fit1<-lm(Weight~Copper+Cobalt,data=sheep.df)
sheep.fit2<-lm(Weight~Cobalt,data=sheep.df)
eovcheck(sheep.fit2)
normcheck(sheep.fit2)
summary1way(sheep.fit2)
multipleComp(sheep.fit2)

data (chalk.df)
interactionPlots(Density~Lab+Chalk,data=chalk.df)
interactionPlots(Density~Chalk+Lab,data=chalk.df)
chalk.df<-within(chalk.df,{Lab.F<-factor(Lab)})
chalk.fit<-lm(Density~Chalk+Lab.F+Chalk*Lab.F,data=chalk.df)
eovcheck(chalk.fit)
summary2way(chalk.fit,page="table")
normcheck(chalk.fit)
summary2way(chalk.fit,page="interaction")
summary2way(chalk.fit,page="means")

data (mozart.df)
interactionPlots(Time~Movement+Period,data=mozart.df)
mozart.fit<-lm(Time~Movement+Period+Movement*Period,data=mozart.df)
eovcheck(mozart.fit)
mozart.fit1<-lm(log(Time)~Movement+Period+Movement*Period,data=mozart.df)
eovcheck(mozart.fit1)
summary2way(mozart.fit1,page="table")
normcheck(mozart.fit1)
summary2way(mozart.fit1,page="interaction")

drug.trial.table<-c(120,60,10,10)
names(drug.trial.table)<-c("Marked","Moderate", "Slight","Stationary")
drug.trial.table
barplot(drug.trial.table,main="Responses to new drug",xlab="response",ylab="frequency")
freq1way(drug.trial.table,c(0.5,0.25,0.1,0.15))

data (incomes.df)
incomes.df$incomes
layout20x(1,2)
hist(incomes.df$incomes,main="Histogram of incomes",xlab="incomes")
boxplot(incomes.df$incomes,main="Boxplot of incomes")
summaryStats(incomes.df$incomes)
normcheck(incomes.df$incomes)
t.test(incomes.df$incomes)

data (house.df)
house.df$advertised.price
house.df$sell.price
house.df<-within(house.df,{price.difference<-advertised.price-sell.price})
house.df$price.difference
layout20x(1,2)
hist(house.df$price.difference,breaks=10)
boxplot(house.df$price.difference,main="Boxplot of price.difference")
summaryStats(house.df$price.difference)
normcheck(house.df$price.difference)
t.test(house.df$price.difference,alt="greater")

data (toothpaste.df)
toothpaste.df
ages<-c(toothpaste.df$purchasers,toothpaste.df$nonpurchasers)
buy<-rep(c("Yes","No"),c(20,20))
buy<-factor(buy)
layout20x(1,2)
boxplot(ages~buy,main="Boxplots for Crest")
stripchart(ages~buy,vert=T,pch=1,main="Stripchart for Crest")
summaryStats(ages~buy)
summaryStats(toothpaste.df$purchasers)
summaryStats(toothpaste.df$nonpurchasers)
crest.fit<-lm(ages~buy)
eovcheck(crest.fit)
normcheck(crest.fit)
t.test(ages~buy,var.equal=T)
t.test(ages~buy,var.equal=T,conf.level=0.9)

data (course.df)
course.df$Exam
stripchart(course.df$Exam,method="stack",pch=1,main="STATS 20x Exam marks",xlab="exam mark")
summaryStats(course.df$Exam)
normcheck(course.df$Exam)
t.test(course.df$Exam)

