% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weibull.R
\name{Weibull}
\alias{Weibull}
\title{Small Area Estimation using Hierarchical Bayesian under Weibull Distribution}
\usage{
Weibull(
  formula,
  iter.update = 3,
  iter.mcmc = 10000,
  coef,
  var.coef,
  thin = 2,
  burn.in = 2000,
  tau.u = 1,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{10000}}

\item{coef}{a vector contains prior initial value of Coefficient of Regression Model for fixed effect with default vector of \code{0} with the length of the number of regression coefficients}

\item{var.coef}{a vector contains prior initial value of variance of Coefficient of Regression Model with default vector of \code{1} with the length of the number of regression coefficients}

\item{thin}{Thinning rate, must be a positive integer with default \code{2}}

\item{burn.in}{Number of iterations to discard at the beginning with default \code{2000}}

\item{tau.u}{Prior initial value of inverse of Variance of area random effect with default \code{1}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method }
   \item{refVar}{Estimated random effect variances}
   \item{coefficient}{A dataframe with the estimated model coefficient}
   \item{plot}{Trace, Dencity, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \eqn{(y)} that assumed to be a Weibull Distribution. The range of data is \eqn{(y > 0}
}
\examples{
\donttest{
#Data Generation
set.seed(123)
m=30
x=runif(m,0,1)
b0=b1=0.5
u=rnorm(m,0,1)
Mu=exp(b0+b1*x+u)
k=rgamma(m,2,1)
lambda=Mu/gamma(1+1/k)
y=rweibull(m,k,lambda)
MU=lambda*gamma(1+1/k)
vardir=lambda^2*(gamma(1+2/k)-(gamma(1+1/k))^2)
dataWeibull=as.data.frame(cbind(y,x,vardir))
dataWeibullNs=dataWeibull
dataWeibullNs$y[c(3,14,22,29,30)] <- NA
dataWeibullNs$vardir[c(3,14,22,29,30)] <- NA


#Compute Fitted Model
#y ~ x


## For data without any nonsampled area

formula = y ~ x
var.coef = c(1,1)
coef = c(0,0)


# Using parameter coef and var.coef
saeHBWeibull <- Weibull(formula,coef=coef,var.coef=var.coef,iter.update=10,data=dataWeibull)
#This example use only 10 observations to make the example execution time be faster

saeHBWeibull$Est                                 #Small Area mean Estimates
saeHBWeibull$refVar                              #Random effect variance
saeHBWeibull$coefficient                         #coefficient
#Load Library 'coda' to execute the plot
#autocorr.plot(saeHBWeibull$plot[[3]]) is used to generate ACF Plot
#plot(saeHBWeibull$plot[[3]]) is used to generate Density and trace plot

# Do not using parameter coef and var.coef
saeHBWeibull <- Weibull(formula, data=dataWeibull)



## For data with nonsampled area use dataWeibullNs

}
}
