% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_diagnostics.R
\name{testnpde}
\alias{testnpde}
\title{Tests for normalised prediction distribution errors}
\usage{
testnpde(npde)
}
\arguments{
\item{npde}{the vector of prediction distribution errors}
}
\value{
a list containing 4 components: 
\item{Wilcoxon test of mean=0}{compares the mean of the npde to 0 using a Wilcoxon test}
\item{variance test }{compares the variance of the npde to 1 using a Fisher test} 
\item{SW test of normality}{compares the npde to the normal  distribution using a Shapiro-Wilks test} 
\item{global test }{p-value for the global test (combination of the mean, variance and distribution tests with a Bonferroni correction)}

The p-values are adjusted using a Bonferroni correction: the raw p-values of the 3 individual tests are multiplied by 3, and the p-value for the global test is equal to the minimum of the adjusted p-values.
}
\description{
Performs tests for the normalised prediction distribution errors returned by
\code{npde}
}
\details{
Given a vector of normalised prediction distribution errors (npde), this
function compares the npde to the standardised normal distribution N(0,1)
using a Wilcoxon test of the mean, a Fisher test of the variance, and a
Shapiro-Wilks test for normality. A global test is also reported.

The helper functions \code{kurtosis} and \code{skewness} are called to
compute the kurtosis and skewness of the distribution of the npde.
}
\references{
K. Brendel, E. Comets, C. Laffont, C. Laveille, and F. Mentr\'e.
Metrics for external model evaluation with an application to the population
pharmacokinetics of gliclazide. \emph{Pharmaceutical Research}, 23:2036--49,
2006.
}
\seealso{
\code{\link{saemix}}, \code{\link{saemix.plot.npde}}
}
\author{
Emmanuelle Comets <emmanuelle.comets@inserm.fr>
}
\keyword{models}
