% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locations.R
\name{add_locations}
\alias{add_locations}
\title{Adds location data to a SAFE data worksheet.}
\usage{
add_locations(
  obj,
  location_field = NULL,
  location_table = NULL,
  gazetteer_info = FALSE
)
}
\arguments{
\item{obj}{An existing object of class \code{safedata}}

\item{location_field}{The name of a location field in a
\code{safedata} object.}

\item{location_table}{An existing location table for a dataset,
as generated by \code{\link{get_locations}}.}

\item{gazetteer_info}{Should all the gazetteer fields be included in
the returned \code{\link[sf]{sf}}  object. See
\code{\link{load_gazetteer}} for details.}
}
\value{
A modified \code{safedata} object including geometry data.
}
\description{
This function adds location data to the rows of a SAFE data worksheet,
converting it into a \code{\link[sf]{sf}} spatial features object. Rows
are matched to values in a location_field: if there is only one location
field, it will be used automatically; otherwise, the specific field must
be provided.
}
\examples{
   set_example_safe_dir()
   beetle_abund <- load_safe_data(1400562, "Ant-Psel")
   beetle_abund <- add_locations(beetle_abund)
   unset_example_safe_dir()
}
\seealso{
\code{\link{get_locations}}, \code{\link{load_gazetteer}},
   \code{\link{load_location_aliases}}
}
