% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkRequired.R
\name{checkRequired}
\alias{checkRequired}
\title{Check that the user has provided a valid for a given settings parameter}
\usage{
checkRequired(key, settings)
}
\arguments{
\item{key}{a list (like those provided by \code{getSettingKeys())} defining the position of parameter in the settings object.}

\item{settings}{The settings list used to generate a chart like \code{eDISH()}}
}
\value{
A list containing the results of the check following the format specified in \code{validateSettings()[["checkList"]]}
}
\description{
Checks that a single required parameter from the settings list is provided by the user
}
\examples{
testSettings<-generateSettings(standard="AdAM")

#pass ($valid == TRUE)
safetyGraphics:::checkRequired(key=list("id_col"),
                                      settings=testSettings) 

#fails since filters aren't specified by default
safetyGraphics:::checkRequired(key=list("filters"),
                                      settings=testSettings) 

#fails since groups aren't specified by default
safetyGraphics:::checkRequired(key=list("groups",1,"value_col"),
                                      settings=testSettings) 
}
\keyword{internal}
