% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hasField.R
\name{hasField}
\alias{hasField}
\title{Check whether a specified field value is found in a data set}
\usage{
hasField(fieldValue, columnName, data)
}
\arguments{
\item{fieldValue}{A value to check for.}

\item{columnName}{The column to check.}

\item{data}{the data.frame to search.}
}
\value{
logical scalar. TRUE if field_value is found. FALSE otherwise
}
\description{
This checks whether a specific value is found in a specified column in a specified data set
}
\examples{
#TRUE
safetyGraphics:::hasField(
 fieldValue="Bilirubin (umol/L)",
 columnName="PARAM",
 data=safetyData::adam_adlbc
)

#FALSE
safetyGraphics:::hasField(
 fieldValue="Not_a_real_value",
 columnName="",
 data=safetyData::adam_adlbc
)

}
\keyword{internal}
