% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_create_job_bulk}
\alias{sf_create_job_bulk}
\title{Create Bulk API Job}
\usage{
sf_create_job_bulk(operation = c("insert", "delete", "upsert", "update",
  "hardDelete", "query"), object_name, external_id_fieldname = NULL,
  api_type = c("Bulk 1.0", "Bulk 2.0"), content_type = c("CSV", "ZIP_CSV",
  "ZIP_XML", "ZIP_JSON"), concurrency_mode = c("Parallel", "Serial"),
  line_ending = NULL, column_delimiter = c("COMMA", "TAB", "PIPE",
  "SEMICOLON", "CARET", "BACKQUOTE"), verbose = FALSE)
}
\arguments{
\item{operation}{character; a string defining the type of operation being 
performed (e.g. "insert", "update", "upsert", "delete")}

\item{object_name}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{external_id_fieldname}{character; string identifying a custom field on the 
object that has been set as an "External ID" field. This field is used to reference 
objects during upserts to determine if the record already exists in Salesforce or not.}

\item{api_type}{character; one of "REST", "SOAP", or "Bulk" indicating 
which API to use when making the request}

\item{content_type}{character; being one of 'CSV', 'ZIP_CSV', 'ZIP_XML', or 'ZIP_JSON' to 
indicate the type of data being passed to the Bulk API}

\item{concurrency_mode}{character; either "Parallel" or "Serial" that specifies whether batches should be completed
sequentially or in parallel. Use "Serial" only if Lock contentions persist with in "Parallel" mode.}

\item{line_ending}{character; indicating the The line ending used for CSV job data, 
marking the end of a data row. The default is NULL and determined by the operating system using 
"CRLF" for Windows machines and "LF" for Unix machines}

\item{column_delimiter}{character; indicating the column delimiter used for CSV job data. 
The default value is COMMA. Valid values are: "BACKQUOTE", "CARET", "COMMA", "PIPE", 
"SEMICOLON", and "TAB".}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{tbl_df} parameters defining the created job, including id
}
\description{
This function initializes a Job in the Salesforce Bulk API
}
\examples{
\dontrun{
# insert into Account
job_info <- sf_create_job_bulk(operation='insert', object_name='Account')

# delete from Account
job_info <- sf_create_job_bulk(operation='delete', object_name='Account')

# update into Account
job_info <- sf_create_job_bulk(operation='update', object_name='Account')

# upsert into Account
job_info <- sf_create_job_bulk(operation='upsert',
                               externalIdFieldName='My_External_Id__c',
                               object_name='Account')
# insert attachments
job_info <- sf_create_job_bulk(operation='insert', object_name='Attachment')

# query leads
job_info <- sf_create_job_bulk(operation='query', object_name='Lead')
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
