% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-metadata.R
\name{sf_list_metadata}
\alias{sf_list_metadata}
\title{List All Objects of a Certain Metadata Type in Salesforce}
\usage{
sf_list_metadata(queries, verbose = FALSE)
}
\arguments{
\item{queries}{a \code{list} of \code{list}s with each element consisting of 2 components: 1) 
the metadata type being requested and 2) the folder associated with the type that required for types 
that use folders, such as Dashboard, Document, EmailTemplate, or Report.}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{tbl_dfs} containing the queried metadata types
}
\description{
This function takes a query of metadata types and returns a 
summary of all objects in salesforce of the requested types
}
\note{
Only 3 queries can be specifed at one time, so the list length must not exceed 3.
}
\examples{
\dontrun{
# pull back a list of all Custom Objects and Email Templates
my_queries <- list(list(type='CustomObject'),
                   list(folder='unfiled$public',
                        type='EmailTemplate'))
metadata_info <- sf_list_metadata(queries=my_queries)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/}
}
