% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attachments.R
\name{sf_create_attachment}
\alias{sf_create_attachment}
\title{Create Attachments}
\usage{
sf_create_attachment(
  input_data,
  object_name = "Attachment",
  api_type = c("SOAP", "REST", "Bulk 1.0", "Bulk 2.0"),
  control = list(...),
  ...,
  verbose = FALSE
)
}
\arguments{
\item{input_data}{\code{named vector}, \code{matrix}, \code{data.frame}, or 
\code{tbl_df}; data can be coerced into a \code{data.frame}. The input must 
contain a column entitled 'Body' with an absolute or relative file path 
(unless creating a Document using a Url) along with other required fields depending 
on the object. See the details below for the other required fields when creating 
Attachments and Documents.}

\item{object_name}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{api_type}{character; one of "REST", "SOAP", "Bulk 1.0", "Bulk 2.0", or 
"Chatter" indicating which API to use when making the request}

\item{control}{\code{list}; a list of parameters for controlling the behavior of 
the API call being used. For more information of what parameters are available 
look at the documentation for \code{\link{sf_control}}}

\item{...}{arguments passed to \code{\link{sf_control}} or further downstream 
to \code{\link{sf_bulk_operation}}}

\item{verbose}{logical; do you want informative messages?}
}
\value{
\code{tbl_df} with details of the created records
}
\description{
This function will allow you to create attachments (and other blob data, such as 
Documents) by supplying file paths (absolute or relative) to media that you 
would like to upload to Salesforce along with accompanying metadata, such as 
a Description, Keywords, ParentId, FolderId, etc.
}
\note{
The length of any file name can’t exceed 512 bytes (per Bulk 1.0 API). 
The SOAP API create call restricts these files to a maximum size of 25 MB. For a file 
attached to a Solution, the limit is 1.5 MB. The maximum email attachment size is 3 MB. 
You can only create or update documents to a maximum size of 5 MB. The REST API 
allows you to insert or update blob data limited to 50 MB of text data or 37.5 MB 
of base64–encoded data.
}
\examples{
\dontrun{
# upload two PDFs from working directory to a particular record as Attachments
file_path1 <- here::here("doc1.pdf")
file_path2 <- here::here("doc2.pdf")
parent_record_id <- "0033s00000zLbgs"
attachment_details <- tibble(Body = c(file_path1, file_path2), 
                             ParentId = rep(parent_record_id, 2))
result <- sf_create_attachment(attachment_details)

# the function supports inserting all blob content, just update the 
# object_name argument to add the PDF as a Document instead of an Attachment
document_details <- tibble(Name = "doc1.pdf", 
                           Description = "Test Document 1", 
                           Body = file_path1,
                           FolderId = "00l6A000001EgIwQAK",
                           Keywords = "example,test,document")
result <- sf_create_attachment(document_details, object_name = "Document")

# the Bulk API can be envoked using api_type="Bulk 1.0" which will automatically 
# take a data.frame of Attachment info and create a ZIP file with CSV manifest 
# that is required for that API
result <- sf_create_attachment(attachment_details, api_type="Bulk 1.0")
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api.meta/api/sforce_api_objects_attachment.htm}

\url{https://developer.salesforce.com/docs/atlas.en-us.api.meta/api/sforce_api_objects_document.htm}

\url{https://developer.salesforce.com/docs/atlas.en-us.api_rest.meta/api_rest/dome_sobject_insert_update_blob.htm}
}
