% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{patched_tempdir}
\alias{patched_tempdir}
\title{Create a temporary directory path without a double slash}
\usage{
patched_tempdir()
}
\value{
\code{character}; a string representing the temp directory path
without containing a double slash
}
\description{
This function fixes a long standing bug in R where the
\code{\link[base:tempfile]{tempdir}} function will return a path with an
extra slash.
}
\note{
This function is meant to be used internally. Only use when debugging.
}
\examples{
\dontrun{
patched_tempdir()
}
}
\seealso{
\href{https://stat.ethz.ch/R-manual/R-devel/library/base/html/EnvVar.html}{R documentation on environment vars}, \href{https://stackoverflow.com/questions/15361980/why-does-tempdir-adds-extra-slash-at-end-of-directory-tree-on-osx/15362110#15362110}{Stack Overflow - Why does tempdir() adds extra slash...}
}
\keyword{internal}
