% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_job_batches_bulk}
\alias{sf_job_batches_bulk}
\title{Checking the Status of a Batch in a Bulk API Job}
\usage{
sf_job_batches_bulk(job_id, api_type = c("Bulk 1.0"), verbose = FALSE)
}
\arguments{
\item{job_id}{\code{character}; the Salesforce Id assigned to a submitted job as
returned by \link{sf_create_job_bulk}. It will start with \code{"750"}.}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
A \code{tbl_df} of parameters defining the batch identified by the batch_id
}
\description{
This function checks on and returns status information on an existing batch
which has already been submitted to Bulk API Job
}
\note{
This is a legacy function used only with Bulk 1.0.
}
\examples{
\dontrun{
job_info <- sf_create_job_bulk(operation = "query", object = "Account")
soql <- "SELECT Id, Name FROM Account LIMIT 10"
batch_query_info <- sf_submit_query_bulk(job_id = job_info$id, soql = soql)
submitted_batches <- sf_job_batches_bulk(job_id=batch_query_info$jobId)
job_close_ind <- sf_close_job_bulk(job_info$id)
sf_get_job_bulk(job_info$id)                               
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch}
}
