% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpro.R
\name{cpro}
\alias{cpro}
\title{Calculate proportion and margin of error (unequal-sized cluster sample)}
\usage{
cpro(df, numerator, denominator, ci = 95, na = "", N = 0)
}
\arguments{
\item{df}{object containing data frame on which to perform analysis}

\item{numerator}{variable in data frame for which you want to calculate proportion and margin of error}

\item{denominator}{variable in data frame containing population sizes of unequal clusters}

\item{ci}{(optional) confidence level for establishing a confidence interval using z-score (defaults to 95; restricted to 80, 85, 90, 95 or 99 as input)}

\item{na}{(optional) value that you want to filter and exclude (defaults to include everything)}

\item{N}{(optional) population universe (e.g. 10000, nrow(df)); if N value is passed as an argument, margin of error will be calculated using fpc}
}
\value{
Returns table of responses (n), proportions, margins of error, lower and upper bounds by factor for a given variable in a stratified sample
}
\description{
Calculate proportion and margin of error (unequal-sized cluster sample)
}
\examples{
alresults <- ssamp(albania, 890, qarku)
cpro(df=alresults, numerator=totalVoters, denominator=zgjedhes, ci=95)
cpro(df=alresults, numerator=pd, denominator=validVotes, ci=95, N=5361)
}
\references{
[1] Survey Sampling, L. Kish, 1965, Equation 6.3.4
[2] Sampling Techniques, W.G. Cochran, 1977, Equation 3.34
}
