% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/santaR_pvalue_dist.R
\name{santaR_pvalue_dist_within}
\alias{santaR_pvalue_dist_within}
\title{Evaluate difference between a group mean curve and a constant model}
\usage{
santaR_pvalue_dist_within(SANTAGroup, nPerm = 1000, nStep = 5000)
}
\arguments{
\item{SANTAGroup}{A fitted group extracted from a \emph{SANTAObj} generated by \code{\link{santaR_fit}}.}

\item{nPerm}{(int) Number of permutations. Default 1000.}

\item{nStep}{(int) Number of steps employed for the calculation of the area between group mean curves. Default is 5000.}
}
\value{
A \emph{p-value}
}
\description{
Execute a t-test based on the comparison of distance between a group mean curve and a constant linear model. Generate \emph{n} constant linear model. The \emph{Null} distribution is generated by permuting the \emph{n} group individuals and the \emph{n} constant trajectories. The real distance (area) between the group trajectory and the flat trajectory is compared to the \emph{Null} distribution of distances, similarly to \code{\link{santaR_pvalue_dist}}.
}
\examples{
## 56 measurements, 8 subjects, 7 unique time-points
## Default parameter values decreased to ensure an execution < 2 seconds
Yi          <- acuteInflammation$data$var_3
ind         <- acuteInflammation$meta$ind
time        <- acuteInflammation$meta$time
group       <- acuteInflammation$meta$group
grouping    <- get_grouping(ind, group)
inputMatrix <- get_ind_time_matrix(Yi, ind, time)
SANTAObj    <- santaR_fit(inputMatrix, df=5, grouping=grouping, verbose=TRUE)
SANTAGroup  <- SANTAObj$groups[[2]]
#SANTAGroup <- SANTAObj$groups$Group2
santaR_pvalue_dist_within(SANTAGroup, nPerm=500)
# ~0.00990099

}
\seealso{
Inter-group comparison with \code{\link{santaR_pvalue_dist}}
}
