% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriveDatetag.R
\name{deriveDatetag}
\alias{deriveDatetag}
\title{Derive datetag from deposition dates in simulated profiles}
\usage{
deriveDatetag(x)
}
\arguments{
\item{x}{a \link{snowprofile} or \link{snowprofileLayers} object}
}
\value{
The \code{x} object will be returned with added columns \code{datetag} and \code{bdate} (i.e., either as \code{snowprofile}, or \code{snowprofileLayers})
}
\description{
This routine derives the datetags of simulated snow profile layers from deposition dates. Datetags usually are deposition dates
for crust layers, and burial dates for other weak layers (e.g., SH, FC). If no datetags can be derived, a datetag column of NAs will
nevertheless be added to the snowprofile layers. The routine also adds a \code{bdate} column for burial dates that are calculated along the way.
}
\examples{
## This is not the most meaningful example, but it nicely illustrates the routine:
print(SPpairs$A_manual)

print(deriveDatetag(SPpairs$A_manual))

}
\author{
fherla
}
