% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.juror.stats.R
\name{compare.juror.stats}
\alias{compare.juror.stats}
\title{Estimates juror-level differences based on sample statistics (from survey)}
\usage{
compare.juror.stats(pg_actual, n_actual, pg_hypo, n_hypo, digits = 3)
}
\arguments{
\item{pg_actual}{The proportion of jurors who favor a guilty verdict in the
actual trial condition (the trial with error).}

\item{n_actual}{The size of the sample used to estimate pg_actual.}

\item{pg_hypo}{The proportion of jurors who favor a guilty verdict in the
hypothetical trial condition (the fair trial without error).}

\item{n_hypo}{The size of the sample used to estimate pg_hypo.}

\item{digits}{Number of digits to report after decimal places; default value is 3.}
}
\value{
Returns a list of juror-level statistics to assess the effect of a trial error or omission on juror preferences.
        Returned list includes statistics for the actual trial, the hypothetical trial, and
        the difference between them.
}
\description{
Calculates juror-level statistics and differences based on sample
             statistics (from a survey) supplied by user.
}
\examples{
   library(sate)
   compare.juror.stats(pg_actual=.70, n_actual=400, pg_hypo=.60, n_hypo=450)

   compare.juror.stats(pg_actual=.75, n_actual=450, pg_hypo=.65, n_hypo=350)
}
