% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-MultiplexSBM_fit.R
\name{MultiplexSBM_fit}
\alias{MultiplexSBM_fit}
\title{R6 Class definition of a Multiplex SBM fit}
\description{
R6 Class definition of a Multiplex SBM fit

R6 Class definition of a Multiplex SBM fit
}
\details{
This class is designed to give a representation and adjust a Multiplex SBM fitted with GREMLIN.

The list of parameters \code{estimOptions} essentially tunes the optimization process and the variational EM algorithm, with the following parameters
\itemize{
\item{"nbCores"}{integer for number of cores used.  Default is 2}
\item{"verbosity"}{integer for verbosity (0, 1). Default is 1}
\item{"nbBlocksRange"}{List of length the number of functional groups, each element supplying the minimal and maximal number of blocks to be explored. The names of the list must be the names of the functional groups.  Default value is from 1 to 10)}
\item{"initBM"}{Boolean. True if using simple and bipartite SBM as initialisations. Default value  = TRUE}
\item{"maxiterVEM"}{Number of max. number of iterations in  the VEM. Default value  = 100}
\item{"maxiterVE"}{Number of max. number of iterations in  the VE. Default value  = 100}
}
}
\section{Super classes}{
\code{\link[sbm:SBM]{sbm::SBM}} -> \code{\link[sbm:MultipartiteSBM]{sbm::MultipartiteSBM}} -> \code{\link[sbm:MultipartiteSBM_fit]{sbm::MultipartiteSBM_fit}} -> \code{MultiplexSBM_fit}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{nbBlocks}}{vector of size 2: number of blocks (rows, columns)}

\item{\code{dependentNetwork}}{: connection parameters in each network}

\item{\code{storedModels}}{data.frame of all models fitted (and stored) during the optimization}

\item{\code{namesLayers}}{: names of the various Networks}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{MultiplexSBM_fit$new()}}
\item \href{#method-optimize}{\code{MultiplexSBM_fit$optimize()}}
\item \href{#method-plot}{\code{MultiplexSBM_fit$plot()}}
\item \href{#method-show}{\code{MultiplexSBM_fit$show()}}
\item \href{#method-predict}{\code{MultiplexSBM_fit$predict()}}
\item \href{#method-clone}{\code{MultiplexSBM_fit$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="rNetwork">}\href{../../sbm/html/SBM.html#method-rNetwork}{\code{sbm::SBM$rNetwork()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="MultipartiteSBM" data-id="print">}\href{../../sbm/html/MultipartiteSBM.html#method-print}{\code{sbm::MultipartiteSBM$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="MultipartiteSBM_fit" data-id="setModel">}\href{../../sbm/html/MultipartiteSBM_fit.html#method-setModel}{\code{sbm::MultipartiteSBM_fit$setModel()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor for Multiplex SBM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultiplexSBM_fit$new(netList, dependentNet = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{netList}}{list of SBM object with}

\item{\code{dependentNet}}{boolean indicating whether dependence is assumed between networks beyond the common dependence on the latent variables}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-optimize}{}}}
\subsection{Method \code{optimize()}}{
estimation of multipartiteSBM via GREMLINS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultiplexSBM_fit$optimize(estimOptions)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{estimOptions}}{options for MultipartiteBM}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\if{latex}{\out{\hypertarget{method-plot}{}}}
\subsection{Method \code{plot()}}{
plot Multiplex Network
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultiplexSBM_fit$plot(
  type = c("data", "expected"),
  ordered = TRUE,
  plotOptions = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character for the type of plot: either 'data' (true connection), 'expected' (fitted connection). Default to 'data'.}

\item{\code{ordered}}{TRUE is the matrices are plotted after reorganization with the blocks. Default value = TRUE}

\item{\code{plotOptions}}{list of plot options for the matrix view}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
show method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultiplexSBM_fit$show(type = "Fit of a Multiplex Stochastic Block Model")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character used to specify the type of SBM}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
prediction under the currently estimated model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultiplexSBM_fit$predict()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list of matrices matrix of expected values for each dyad
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MultiplexSBM_fit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
