% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-SimpleSBM_fit.R
\name{SimpleSBM_fit}
\alias{SimpleSBM_fit}
\title{R6 Class definition of a Simple SBM fit}
\description{
R6 Class definition of a Simple SBM fit

R6 Class definition of a Simple SBM fit
}
\details{
This class is designed to give a representation and adjust an SBM fitted with blockmodels.

The list of parameters \code{estimOptions} essentially tunes the optimization process and the variational EM algorithm, with the following parameters
\itemize{
\item{"nbCores"}{integer for number of cores used. Default is 2}
\item{"verbosity"}{integer for verbosity (0, 1). Default is 1}
\item{"plot"}{boolean, should the ICL by dynamically plotted or not. Default is TRUE}
\item{"exploreFactor"}{control the exploration of the number of groups}
\item{"exploreMin"}{explore at least until exploreMin even if the exploration factor rule is achieved. Default 4. See the package blockmodels for details.}
\item{"exploreMin"}{Stop exploration at exploreMax  even if the exploration factor rule is not achieved. Default Inf. See the package blockmodels for details.}
\item{"fast"}{logical: should approximation be used for Bernoulli model with covariates. Default to \code{TRUE}}
}
}
\section{Super classes}{
\code{\link[sbm:SBM]{sbm::SBM}} -> \code{\link[sbm:SimpleSBM]{sbm::SimpleSBM}} -> \code{SimpleSBM_fit}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{loglik}}{double: approximation of the log-likelihood (variational lower bound) reached}

\item{\code{ICL}}{double: value of the integrated classification log-likelihood}

\item{\code{penalty}}{double, value of the penalty term in ICL}

\item{\code{entropy}}{double, value of the entropy due to the clustering distribution}

\item{\code{storedModels}}{data.frame of all models fitted (and stored) during the optimization}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SimpleSBM_fit-new}{\code{SimpleSBM_fit$new()}}
\item \href{#method-SimpleSBM_fit-optimize}{\code{SimpleSBM_fit$optimize()}}
\item \href{#method-SimpleSBM_fit-setModel}{\code{SimpleSBM_fit$setModel()}}
\item \href{#method-SimpleSBM_fit-reorder}{\code{SimpleSBM_fit$reorder()}}
\item \href{#method-SimpleSBM_fit-show}{\code{SimpleSBM_fit$show()}}
\item \href{#method-SimpleSBM_fit-clone}{\code{SimpleSBM_fit$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="print"><a href='../../sbm/html/SBM.html#method-SBM-print'><code>sbm::SBM$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="rNetwork"><a href='../../sbm/html/SBM.html#method-SBM-rNetwork'><code>sbm::SBM$rNetwork()</code></a></span></li>
<li><span class="pkg-link" data-pkg="sbm" data-topic="SimpleSBM" data-id="plot"><a href='../../sbm/html/SimpleSBM.html#method-SimpleSBM-plot'><code>sbm::SimpleSBM$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="sbm" data-topic="SimpleSBM" data-id="predict"><a href='../../sbm/html/SimpleSBM.html#method-SimpleSBM-predict'><code>sbm::SimpleSBM$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="sbm" data-topic="SimpleSBM" data-id="rEdges"><a href='../../sbm/html/SimpleSBM.html#method-SimpleSBM-rEdges'><code>sbm::SimpleSBM$rEdges()</code></a></span></li>
<li><span class="pkg-link" data-pkg="sbm" data-topic="SimpleSBM" data-id="rMemberships"><a href='../../sbm/html/SimpleSBM.html#method-SimpleSBM-rMemberships'><code>sbm::SimpleSBM$rMemberships()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleSBM_fit-new"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleSBM_fit-new}{}}}
\subsection{Method \code{new()}}{
constructor for a Simple SBM fit
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$new(
  adjacencyMatrix,
  model,
  directed,
  dimLabels = c(node = "nodeName"),
  covarList = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{adjacencyMatrix}}{square (weighted) matrix}

\item{\code{model}}{character (\code{'bernoulli'}, \code{'poisson'}, \code{'gaussian'})}

\item{\code{directed}}{logical, directed network or not. In not, \code{adjacencyMatrix} must be symmetric.}

\item{\code{dimLabels}}{list of labels of each dimension (in row, in columns)}

\item{\code{covarList}}{and optional list of covariates, each of whom must have the same dimension as \code{adjacencyMatrix}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleSBM_fit-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleSBM_fit-optimize}{}}}
\subsection{Method \code{optimize()}}{
function to perform optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$optimize(estimOptions = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{estimOptions}}{a list of parameters controlling the inference algorithm and model selection. See details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleSBM_fit-setModel"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleSBM_fit-setModel}{}}}
\subsection{Method \code{setModel()}}{
method to select a specific model among the ones fitted during the optimization.
Fields of the current SBM_fit will be updated accordingly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$setModel(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{integer, the index of the model to be selected (row number in storedModels)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleSBM_fit-reorder"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleSBM_fit-reorder}{}}}
\subsection{Method \code{reorder()}}{
permute group labels by order of decreasing probability
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$reorder()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleSBM_fit-show"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleSBM_fit-show}{}}}
\subsection{Method \code{show()}}{
show method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$show(type = "Fit of a Simple Stochastic Block Model")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character used to specify the type of SBM}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleSBM_fit-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleSBM_fit-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
