% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCR.ClonalStateDistribution.R
\name{TCR.ClonalStateDistribution}
\alias{TCR.ClonalStateDistribution}
\title{Distribution of clonal status of single-cell TCR clonotypes}
\usage{
TCR.ClonalStateDistribution(contigList, sampleName)
}
\arguments{
\item{contigList}{The product of TCR.ContigList() or BCR.ContigList().}

\item{sampleName}{The sample name of single cell sample.}
}
\value{
Multiple pictures in the form of a list.
}
\description{
Distribution of clonal status of single-cell TCR clonotypes
}
\examples{

project_data_dir <- "F:/R_Language/data/tcr"
sample_name <- list.dirs(project_data_dir, full.names = FALSE, recursive = FALSE)
group_name <- c("A", "A", "B", "B")

contig_list <- TCR.ContigList(project_data_dir, sample_name, group_name)

TCR.ClonalStateDistribution(contig_list, sample_name)

BasicPlot(TCR.ClonalStateDistribution, contig_list, sample_name)

}
