% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat_to_generes.R
\name{seurat_to_generes}
\alias{seurat_to_generes}
\title{Identify all cell-type markers}
\usage{
seurat_to_generes(pbmc, test = "wilcox")
}
\arguments{
\item{pbmc}{Processed Seurat object.}

\item{test}{statistical test for calling CT markers -- must be in Seurat.}
}
\value{
\code{seurat_to_generes} A list of genes where their over-representation in the i'th cell-type is computed. Each element contains the gene name, adjusted p-value, and the log2Fold-Change of each gene being present in that cell-type. \cr
}
\description{
Takes processed Seurat matrix and identifies cell-type markers with FindMarkers in Seurat.
}
\details{
Internal: This function runs the FindMarkers function from Seurat in a loop, will use the Seurat v2 or Seurat v3 object after identifying which Seurat object is inputted. 
It then takes the output of the FindMarkers and puts it in a list, returning it.
}
\examples{
\donttest{  
 
data(sm)
toProcess <- list(example = sm)
tst1 <- process_from_count(toProcess, "testProcess")
generes <- seurat_to_generes(tst1)
}

}
