% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nap.R
\name{nap}
\alias{nap}
\title{Non-overlap of All Pairs (NAP) Analysis}
\usage{
nap(
  .df,
  .y,
  .phase,
  .time,
  type = c("reversability", "trend"),
  last_m = NULL,
  phases,
  improvement = c("positive", "negative")
)
}
\arguments{
\item{.df}{A data frame containing the data to be analyzed.}

\item{.y}{Character string specifying the variable in \code{.df} to be analyzed.}

\item{.phase}{Character string specifying the variable in \code{.df} that defines
the phases.}

\item{.time}{Character string specifying the time variable in \code{.df}.}

\item{type}{Character string indicating the type of analysis to be conducted:
either "reversability" or "trend".}

\item{last_m}{An integer specifying the number of measurements from the end
to be considered in a trend analysis. Leave as NULL if \code{type} is set
to "reversability".}

\item{phases}{Vector specifying the phases to be included in the analysis.
If \code{type} is "reversability", two phases must be specified. If \code{type}
is "trend", one phase must be specified.}

\item{improvement}{Character vector indicating the direction of improvement to
consider: either "positive" or "negative".}
}
\value{
A numeric value representing the NAP score, reflecting the proportion
of non-overlapping data points between the specified phases or trends.
}
\description{
This function performs a Non-overlap of All Pairs (NAP) analysis on a given
data frame, considering specified phases, improvement direction, and analysis
type (reversability or trend). It is designed to assess the distinctiveness of
data across phases or trends within the data, based on the concept outlined in
the What Works Clearinghouse Procedures and Standards Handbook.
}
\details{
The NAP analysis is a method used to evaluate the effectiveness of interventions
by analyzing the non-overlap between data points across different phases or
trends within a dataset. It is a useful statistical tool for educational research
and is detailed in the What Works Clearinghouse Procedures and Standards Handbook,
Version 5.0.
}
\examples{
nap(.df = reversal_withdrawal, .y = "extbehavs", .phase = "phase",
    .time = "time", type = "reversability",
    phases = list("baseline1", "baseline2"), improvement = "negative")

}
\references{
What Works Clearinghouse. (2022). What Works Clearinghouse procedures and
standards handbook, version 5.0. U.S. Department of Education, Institute of
Education Sciences, National Center for Education Evaluation and Regional
Assistance (NCEE). This report is available on the What Works Clearinghouse
website at \url{https://ies.ed.gov/ncee/wwc/Handbooks}.
}
