% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protection.R
\name{find_prot_titre_val}
\alias{find_prot_titre_val}
\title{Search function for scaled logit protection covariate levels}
\usage{
find_prot_titre_val(
  fit,
  var_name,
  newdata = NULL,
  prot_var_name = "prot_point",
  lvl = 0.5,
  ci_level = 0.95,
  tol = 10^(-7)
)
}
\arguments{
\item{fit}{Object returned by \code{\link{sclr}}.}

\item{var_name}{Name of the covariate for which the protection values should
be calculated. This name should appear in the formula of the call to
\code{\link{sclr}} which was used to generate \code{fit}.}

\item{newdata}{A dataframe with all covariates except the one for which
protection values should be calculated.}

\item{prot_var_name}{A variable name among those returned by
\code{\link{predict.sclr}} which needs to equal \code{lvl} at the value of
\code{var_name} that is supposed to be found.}

\item{lvl}{Protection level to find titre values for. Default is 0.5 (50\%).}

\item{ci_level}{Confidence level for the calculated interval. 
Default is 0.95.}

\item{tol}{Tolerance. The values will be found numerically,
once the algorithm converges within \code{tol} of \code{lvl} 
it stops looking. Default is \eqn{10^(-7)}.}
}
\value{
A dataframe. Will have the same variables as \code{newdata} with
the addition of the \code{var_name} variable.
}
\description{
The search engine behind \code{\link{get_protection_level}}. Should not
usually be necessary to call this directly.
}
