% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_hot.R
\name{replace_na}
\alias{replace_na}
\title{Replace Missing Values}
\usage{
replace_na(dt, repl)
}
\arguments{
\item{dt}{A data frame or vector.}

\item{repl}{Replace missing values with a specified value such as -1, or the mean/median value for numeric variable and mode value for categorical variable if repl is mean or median.}
}
\description{
Replace missing values with a specified value or mean/median value.
}
\examples{
# load germancredit data
data(germancredit)

library(data.table)
dat = rbind(
  setDT(germancredit)[, c(sample(20,3),21)],
  data.table(creditability=sample(c("good","bad"),10,replace=TRUE)),
  fill=TRUE)

## replace with -1
dat_repna1 = replace_na(dat, repl = -1)
## replace with median for numeric, and mode for categorical
dat_repna2 = replace_na(dat, repl = 'median')
## replace with mean for numeric, and mode for categorical
dat_repna3 = replace_na(dat, repl = 'mean')

}
