# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

abort_recording <- function() {
    invisible(.Call(`_scorematchingad_abort_recording`))
}

#' @noRd
#' @describeIn evaltape_internal The value of a recorded function approximated by Taylor expansion.
#' Returns the approximate value of `pfun` at `x`.
#' @details
#' # taylorApprox_currentdynparam evaluates the tape without updating the dynamic parameter value 
#' Approximates the value of a `CppAD` tape at `x` using a Taylor approximation at `centre`. The dynamic parameters of the tape are set by `dynparam`.
#' @param centre For pTaylorApprox. A vector in the domain of the taped function to approximate the value at `x` from.
#' @param order For pTaylorApprox. The order of Taylor expansion to use.
taylorApprox_currentdynparam <- function(pfun, x, centre, order) {
    .Call(`_scorematchingad_taylorApprox_currentdynparam`, pfun, x, centre, order)
}

#' @noRd
#' @describeIn evaltape_internal The value of a recorded function approximated by Taylor expansion.
#' Returns the approximate value of `pfun` at `x`.
taylorApprox <- function(pfun, x, centre, dynparam, order) {
    .Call(`_scorematchingad_taylorApprox`, pfun, x, centre, dynparam, order)
}

#' @title Average Across Range of a Tape
#' @family tape builders
#' @param pfun An `Rcpp_ADFun` object.
#' @description Creates a `CppAD` tape that is the average of the returned values of `pfun`.
#' For creating this tape, the values of `pfun$dyntape` and `pfun$xtape` are used.
#' @return An `Rcpp_ADFun` object.
#' @export
avgrange <- function(pfun) {
    .Call(`_scorematchingad_avgrange`, pfun)
}

set_cppad_error_handler <- function() {
    invisible(.Call(`_scorematchingad_set_cppad_error_handler`))
}

test_Rcpphandler <- function() {
    invisible(.Call(`_scorematchingad_test_Rcpphandler`))
}

#' @title Fix Dynamic Parameters of a Tape
#' @family tape builders
#' @param pfun An `Rcpp_ADFun` object.
#' @param theta A numerical vector specifying the value of all dynamic parameters of `pfun`. Some of these will be fixed according to `isfixed`, the remainder will remain dynamic.
#' @param isfixed A boolean vector same length as `theta`. `TRUE` values are fixed at the value of `theta`, `FALSE` values are left dynamic.
#' @description Retapes an existing `CppAD` tape but with some of original dynamic parameters fixed to specified values.
#' For creating this tape, the values of `pfun$xtape` is used.
#' @return An `Rcpp_ADFun` object.
#' @export
fixdynamic <- function(pfun, theta, isfixed) {
    .Call(`_scorematchingad_fixdynamic`, pfun, theta, isfixed)
}

reembed <- function(uld, tran) {
    .Call(`_scorematchingad_reembed`, uld, tran)
}

#' @title Fix Independent Arguments of a Tape
#' @family tape builders
#' @param pfun An `Rcpp_ADFun` object.
#' @param x A numerical vector specifying the value of all independent arguments of `pfun`. Some of these will be fixed according to `isfixed`, the remainder will remain as independent arguments.
#' @param isfixed A boolean vector same length as `x`. `TRUE` values are fixed at the value of `x`, `FALSE` values are left as independent arguments.
#' @description Retapes an existing `CppAD` tape but with some of original independent arguments fixed to specified values.
#' For creating this tape, the values of `pfun$dyntape` are used.
#' @return An `Rcpp_ADFun` object.
#' @export
fixindependent <- function(pfun, x, isfixed) {
    .Call(`_scorematchingad_fixindependent`, pfun, x, isfixed)
}

#' @title Reduce Range Dimension of a Tape
#' @family tape builders
#' @param pfun An `Rcpp_ADFun` object.
#' @param keep Integers (lowest of 1, highest of `pfun$range`) specifying which elements of the range to keep. To keep all pass `keep = seq(1, pfun$range)`.
#' @description Retapes an existing `CppAD` tape omitting some of the returned elements.
#' For creating this tape, the values of `pfun$dyntape` and `pfun$xtape` are used.
#' @return An `Rcpp_ADFun` object.
#' @export
keeprange <- function(pfun, keep) {
    .Call(`_scorematchingad_keeprange`, pfun, keep)
}

#' @title Tape the Jacobian of CppAD Tape
#' @family tape builders
#' @param pfun An `Rcpp_ADFun` object.
#' @description Creates a tape of the Jacobian of a function taped by `CppAD`.
#' When the function returns a real value (as is the case for densities and the score matching objective) the Jacobian is equivalent to the gradient.
#' The `x` vector is used as the value to conduct the taping.
#' @details
#' When the returned tape is evaluated (via say `$eval()`, the resultant vector contains the Jacobian in long format (see <https://cppad.readthedocs.io/latest/Jacobian.html>).
#' Suppose the function represented by `pfun` maps from \eqn{n}-dimensional space to \eqn{m}-dimensional space, then
#' the first \eqn{n} elements of vector is the gradient of the first component of function output.
#' The next \eqn{n} elements of the vector is the gradient of the second component of the function output.
#' The Jacobian as a matrix, could then be obtained by [`as.matrix()`] with `byrow = TRUE` and `ncol = n`.
#'
#' For creating this tape, the values of `pfun$xtape` and `pfun$dyntape` are used.
#' @return An `Rcpp_ADFun` object.
#' @export
tape_Jacobian <- function(pfun) {
    .Call(`_scorematchingad_tape_Jacobian`, pfun)
}

#' @title Tape the Hessian of a CppAD Tape
#' @family tape builders
#' @inheritParams tape_Jacobian
#' @description Creates a tape of the Hessian of a function taped by `CppAD`.
#' The taped function represented by `pfun` must be scalar-valued (i.e. a vector of length 1).
#' The `x` vector and `dynparam` are used as the values to conduct the taping.
#' @details
#' When the returned tape is evaluated (via say [`eval()`][Rcpp_ADFun-class]), the resultant vector contains the Hessian in long format (see <https://cppad.readthedocs.io/latest/Hessian.html>):
#' suppose the function represented by `pfun` maps from \eqn{n}-dimensional space to \eqn{1}-dimensional space, then
#' the first \eqn{n} elements of the vector is the gradient of the partial derivative with respect to the first dimension of the function's domain;
#' the next \eqn{n} elements of the vector is the gradient of the partial derivative of the second dimension of the function's domain.
#' The Hessian as a matrix, can be obtained by using [`as.matrix()`] with `ncol = n`.
#'
#' For creating this tape, the values of `pfun$xtape` and `pfun$dyntape` are used.
#' @return An `Rcpp_ADFun` object.
#' @export
tape_Hessian <- function(pfun) {
    .Call(`_scorematchingad_tape_Hessian`, pfun)
}

#' @title Tape the Gradient Offset of a Quadratic CppAD Tape
#' @family tape builders
#' @inheritParams tape_Jacobian
#' @return An `Rcpp_ADFun` object. The independent argument to the function are the dynamic parameters of `pfun`.
#' @details A quadratic function can be written as
#' \deqn{f(x;\theta) = \frac{1}{2} x^T W(\theta) x + b(\theta)^Tx + c.}
#' The gradient of \eqn{f(x; \theta)} with respect to \eqn{x} is
#' \deqn{\Delta f(x; \theta) = \frac{1}{2}(W(\theta) + W(\theta)^T)x + b(\theta).}
#' The Hessian is 
#' \deqn{H f(x; \theta) = \frac{1}{2}(W(\theta) + W(\theta)^T),}
#' which does not depend on \eqn{x},
#' so the gradient of the function can be rewritten as
#' \deqn{\Delta f(x;\theta) = H f(x; \theta) x + b(\theta)^T.}
#' The tape calculates \eqn{b(\theta)} as
#'  \deqn{b(\theta) = \Delta f(x;\theta) - H f(x; \theta) x,}
#' which does not depend on \eqn{x}.
#'
#' For creating this tape, the values of `pfun$xtape` and `pfun$dyntape` are used.
#' @export
tape_gradoffset <- function(pfun) {
    .Call(`_scorematchingad_tape_gradoffset`, pfun)
}

#' @title Tape the log of Jacobian determinant of a CppAD Tape
#' @family tape builders
#' @inheritParams tape_Jacobian
#' @description Creates a tape of the log of the Jacobian determinant of a function taped by CppAD.
#' The `x` vector is used as the value to conduct the taping.
#'
#' For creating this tape, the values of `pfun$xtape` and `pfun$dyntape` are used.
#' @return An `Rcpp_ADFun` object.
#' @export
tape_logJacdet <- function(pfun) {
    .Call(`_scorematchingad_tape_logJacdet`, pfun)
}

#' @title Switch Dynamic and Independent Values of a Tape
#' @family tape builders
#' @inheritParams tape_Jacobian
#' @description Convert an `Rcpp_ADFun` object so that the independent values become dynamic parameters
#' and the dynamic parameters become independent values
#' @details
#' For creating this tape, the values of `pfun$xtape` and `pfun$dyntape` are used.
#' @return An `Rcpp_ADFun` object.
#' @export
tape_swap <- function(pfun) {
    .Call(`_scorematchingad_tape_swap`, pfun)
}

#' @rdname tape_bdryw
#' @name tape_bdryw
#' @param name Name of an inbuilt function. See details.
#' @param acut The \eqn{a_c} threshold used by the "minsq" and "prodsq" built-in functions. See details.
#' @details
#' For `tape_bdryw_inbuilt()`, currently available functions are:
#' * The function "ones" applies no weights and should be used whenever the manifold does not have a boundary.
#' \deqn{h(x)^2 = 1.}
#' * The function "minsq" is the minima-based boundary weight function \insertCite{@Equation 12, @scealy2023sc}{scorematchingad}
#' \deqn{h(x)^2 = \min(x_1^2, x_2^2, ..., x_p^2, a_c^2).}{h(x)^2 = min(x1^2, x2^2, ..., xp^2, a_c^2),}
#' where \eqn{x_j}{xj} is the jth component of x. 
#' * The function "prodsq" is the product-based \insertCite{@Equation 9, @scealy2023sc}{scorematchingad}
#' \deqn{h(x)^2 = \min(\prod_{j=1}^{p} x_j^2, a_c^2).}{h(x)^2 = min(x1^2 * x2^2 * ... * xp^2, a_c^2),}
#' where \eqn{x_j}{xj} is the jth component of x.
#'
#' The "minsq" and "prodsq" functions are useful when the manifold is the positive orthant, the p-dimensional unit sphere restricted to the positive orthant, or the unit simplex.
#' \insertCite{@scealy2023sc}{scorematchingad} prove that both "minsq" and "prodsq" can be used for score matching the PPI model on the simplex or positive orthant of the sphere.
#' @export
tape_bdryw_inbuilt <- function(name, x, acut) {
    .Call(`_scorematchingad_tape_bdryw_inbuilt`, name, x, acut)
}

#' @noRd
#' @title Get an XPtr to a named log-density function in source code of package
#' @param llname name of the likelihood function
#' @return An RCpp::XPtr object pointing to a `llPtr` object of the log-density function. Since `llPtr` is itself a pointer object, we have an XPtr pointing to a pointer that points to a function.
getllptr <- function(llname) {
    .Call(`_scorematchingad_getllptr`, llname)
}

#' @rdname tape_uld
#' @name tape_uld
#' @param name Name of an inbuilt function. See details.
#' @details
#' For `tape_uld_inbuilt()`, currently available unnormalised log-density functions are:
#'
#' ```{r, results = "asis", echo = FALSE}
#' cat(paste(" +", llnames), sep = "\n")
#' ```
#' @export
tape_uld_inbuilt <- function(name, x, theta) {
    .Call(`_scorematchingad_tape_uld_inbuilt`, name, x, theta)
}

#' @noRd
#' @title The score matching objective calculator.
#' @param xbetain a concatenated vector of sqrt(x) and beta
#' @param n The dimension of x.
#' @param manifoldname The name of the manifold to transform to
#' @param weightname The name of the weight function to use
#' @param acut The constraint a_c in the weight function
#' @return An RCpp::XPtr object pointing to the ADFun
tapesmd <- function(uldtape, tran, M, bdrywtape, verbose) {
    .Call(`_scorematchingad_tapesmd`, uldtape, tran, M, bdrywtape, verbose)
}

