% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split-by-parens.R
\name{split_by_parens}
\alias{split_by_parens}
\title{Split columns by parentheses, brackets, braces, or similar}
\usage{
split_by_parens(
  data,
  cols = everything(),
  check_sep = TRUE,
  keep = FALSE,
  transform = FALSE,
  sep = "parens",
  end1 = "x",
  end2 = "sd",
  ...
)
}
\arguments{
\item{data}{Data frame.}

\item{cols}{Select columns from \code{data} using
\href{https://tidyselect.r-lib.org/reference/language.html}{tidyselect}.
Default is \code{everything()}, which selects all columns that pass \code{check_sep}.}

\item{check_sep}{Logical. If \code{TRUE} (the default), columns are excluded if
they don't contain the \code{sep} elements.}

\item{keep}{Logical. If set to \code{TRUE}, the originally selected columns that
were split by the function also appear in the output. Default is \code{FALSE}.}

\item{transform}{Logical. If set to \code{TRUE}, the output will be pivoted to be
better suitable for typical follow-up tasks. Default is \code{FALSE}.}

\item{sep}{String. What to split by. Either \code{"parens"}, \code{"brackets"}, or
\code{"braces"}; or a length-2 vector of custom separators (see Examples).
Default is \code{"parens"}.}

\item{end1, end2}{Strings. Endings of the two column names that result from
splitting a column. Default is \code{"x"} for \code{end1} and \code{"sd"} for \code{end2}.}

\item{...}{These dots must be empty.}
}
\value{
Data frame.
}
\description{
Summary statistics are often presented like \code{"2.65 (0.27)"}.
When working with tables copied into R, it can be tedious to separate
values before and inside parentheses. \code{split_by_parens()} does this
automatically.

By default, it operates on all columns. Output can optionally be pivoted
into a longer format by setting \code{transform} to \code{TRUE}.

Choose separators other than parentheses with the \code{sep} argument.
}
\examples{
# Call `split_by_parens()` on data like these:
df1 <- tibble::tribble(
  ~drone,           ~selfpilot,
  "0.09 (0.21)",    "0.19 (0.13)",
  "0.19 (0.28)",    "0.53 (0.10)",
  "0.62 (0.16)",    "0.50 (0.11)",
  "0.15 (0.35)",    "0.57 (0.16)",
)

# Basic usage:
df1 \%>\%
  split_by_parens()

# Name specific columns with `cols` to only split those:
df1 \%>\%
  split_by_parens(cols = drone)

# Pivot the data into a longer format
# by setting `transform` to `TRUE`:
df1 \%>\%
  split_by_parens(transform = TRUE)

# Choose different column names or
# name suffixes with `end1` and `end2`:
df1 \%>\%
  split_by_parens(end1 = "beta", end2 = "se")

df1 \%>\%
  split_by_parens(
    transform = TRUE,
    end1 = "beta", end2 = "se"
  )

# With a different separator...
df2 <- tibble::tribble(
  ~drone,           ~selfpilot,
  "0.09 [0.21]",    "0.19 [0.13]",
  "0.19 [0.28]",    "0.53 [0.10]",
  "0.62 [0.16]",    "0.50 [0.11]",
  "0.15 [0.35]",    "0.57 [0.16]",
)

# ... specify `sep`:
df2 \%>\%
  split_by_parens(sep = "brackets")

# (Accordingly with `{}` and `"braces"`.)

# If the separator is yet a different one...
df3 <- tibble::tribble(
  ~drone,           ~selfpilot,
  "0.09 <0.21>",    "0.19 <0.13>",
  "0.19 <0.28>",    "0.53 <0.10>",
  "0.62 <0.16>",    "0.50 <0.11>",
  "0.15 <0.35>",    "0.57 <0.16>",
)

# ... `sep` should be a length-2 vector
# that contains the separating elements:
df3 \%>\%
  split_by_parens(sep = c("<", ">"))
}
\seealso{
\itemize{
\item \code{\link[=before_parens]{before_parens()}} and \code{\link[=inside_parens]{inside_parens()}} take a string vector and
extract values from the respective position.
\item \code{\link[dplyr:across]{dplyr::across()}} powers the application of the two above functions
within split_by_parens()`, including the creation of new columns.
\item \code{\link[tidyr:separate_wider_delim]{tidyr::separate_wider_delim()}} is a more general function, but it does
not recognize closing elements such as closed parentheses.
}
}
