% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/generics_problemInstance.r, R/methods_class_problemInstance.r
\docType{methods}
\name{get.problemInstance}
\alias{get.problemInstance}
\alias{get.problemInstance,problemInstance,character-method}
\title{query \code{problemInstance}-objects depending on argument \code{type}}
\usage{
get.problemInstance(object, type)

\S4method{get.problemInstance}{problemInstance,character}(object, type)
}
\arguments{
\item{object}{an object of class \code{problemInstance}}

\item{type}{a character vector of length 1 defining what to calculate|return|modify. Allowed types are:}
\itemize{
\item strID: vector of unique IDs for each table cell
\item nrVars: total number of table cells
\item freq: vector of frequencies
\item w: a vector of weights used in the linear problem (or NULL)
\item numVars: a list containing numeric vectors containing values for numerical variables for each table cell (or NULL)
\item sdcStatus: a vector containing the suppression state for each cell (possible values are 'u': primary suppression, 'x': secondary suppression, 'z': forced for publication, 's': publishable cell, 'w': dummy cells that are considered only when applying the simple greedy heuristic to protect the table)
\item lb: lower bound assumed to be known by attackers for each table cell
\item ub: upper bound assumed to be known by attackers for each table cell
\item LPL: lower protection level required to protect table cells
\item UPL: upper protection level required to protect table cells
\item SPL: sliding protection level required to protect table cells
\item primSupps: vector of indices of primary sensitive cells
\item secondSupps: vector of indices of secondary suppressed cells
\item forcedCells: vector of indices of cells that must not be suppressed
\item hasPrimSupps: shows if \code{object} has primary suppressions or not
\item hasSecondSupps: shows if \code{object} has secondary suppressions or not
\item hasForcedCells: shows if \code{object} has cells that must not be suppressed
\item weight: gives weight that is used the suppression procedures
\item suppPattern: gives the current suppression pattern}
}
\value{
information from objects of class \code{dataObj} depending on argument \code{type}
\itemize{
\item a list (or NULL) if argument \code{type} matches 'numVars'
\item numeric vector if argument \code{type} matches 'freq', 'lb', 'ub', 'LPL', 'UPL', 'SPL', 'weight', 'suppPattern'
\item numeric vector (or NULL) if argument \code{type} matches 'w', 'primSupps', 'secondSupps', 'forcedCells'
\item character vector if argument \code{type} matches 'strID', 'sdcStatus', ''
\item logical vector of length 1 if argument \code{type} matches 'hasPrimSupps', 'hasSecondSupps', 'hasForcedCells'
\item numerical vector of length 1 if argument \code{type} matches 'nrVars'
}
}
\description{
query \code{problemInstance}-objects depending on argument \code{type}
}
\note{
internal function
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}

